package zio.aws.imagebuilder.model
import scala.jdk.CollectionConverters.*
sealed trait ContainerRepositoryService {
  def unwrap: software.amazon.awssdk.services.imagebuilder.model.ContainerRepositoryService
}
object ContainerRepositoryService {
  def wrap(
      value: software.amazon.awssdk.services.imagebuilder.model.ContainerRepositoryService
  ): zio.aws.imagebuilder.model.ContainerRepositoryService = value match {
    case software.amazon.awssdk.services.imagebuilder.model.ContainerRepositoryService.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.imagebuilder.model.ContainerRepositoryService.ECR =>
      val r = ECR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.imagebuilder.model.ContainerRepositoryService {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ContainerRepositoryService =
      software.amazon.awssdk.services.imagebuilder.model.ContainerRepositoryService.UNKNOWN_TO_SDK_VERSION
  }
  case object ECR
      extends zio.aws.imagebuilder.model.ContainerRepositoryService {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ContainerRepositoryService =
      software.amazon.awssdk.services.imagebuilder.model.ContainerRepositoryService.ECR
  }
}
