package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  ImageBuilderArn,
  DateTime,
  VersionNumber,
  OsVersion,
  NonEmptyString,
  ResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ComponentVersion(
    arn: Optional[ImageBuilderArn] = Optional.Absent,
    name: Optional[ResourceName] = Optional.Absent,
    version: Optional[VersionNumber] = Optional.Absent,
    description: Optional[NonEmptyString] = Optional.Absent,
    platform: Optional[zio.aws.imagebuilder.model.Platform] = Optional.Absent,
    supportedOsVersions: Optional[Iterable[OsVersion]] = Optional.Absent,
    `type`: Optional[zio.aws.imagebuilder.model.ComponentType] =
      Optional.Absent,
    owner: Optional[NonEmptyString] = Optional.Absent,
    dateCreated: Optional[DateTime] = Optional.Absent,
    status: Optional[zio.aws.imagebuilder.model.ComponentStatus] =
      Optional.Absent,
    productCodes: Optional[
      Iterable[zio.aws.imagebuilder.model.ProductCodeListItem]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ComponentVersion = {
    import ComponentVersion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ComponentVersion
      .builder()
      .optionallyWith(
        arn.map(value => ImageBuilderArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        version.map(value => VersionNumber.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .optionallyWith(
        supportedOsVersions.map(value =>
          value.map { item =>
            OsVersion.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.supportedOsVersions)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        owner.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.owner)
      .optionallyWith(
        dateCreated.map(value => DateTime.unwrap(value): java.lang.String)
      )(_.dateCreated)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        productCodes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.productCodes)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.ComponentVersion.ReadOnly =
    zio.aws.imagebuilder.model.ComponentVersion.wrap(buildAwsValue())
}
object ComponentVersion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ComponentVersion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ComponentVersion =
      zio.aws.imagebuilder.model.ComponentVersion(
        arn.map(value => value),
        name.map(value => value),
        version.map(value => value),
        description.map(value => value),
        platform.map(value => value),
        supportedOsVersions.map(value => value),
        `type`.map(value => value),
        owner.map(value => value),
        dateCreated.map(value => value),
        status.map(value => value),
        productCodes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def arn: Optional[ImageBuilderArn]
    def name: Optional[ResourceName]
    def version: Optional[VersionNumber]
    def description: Optional[NonEmptyString]
    def platform: Optional[zio.aws.imagebuilder.model.Platform]
    def supportedOsVersions: Optional[List[OsVersion]]
    def `type`: Optional[zio.aws.imagebuilder.model.ComponentType]
    def owner: Optional[NonEmptyString]
    def dateCreated: Optional[DateTime]
    def status: Optional[zio.aws.imagebuilder.model.ComponentStatus]
    def productCodes: Optional[
      List[zio.aws.imagebuilder.model.ProductCodeListItem.ReadOnly]
    ]
    def getArn: ZIO[Any, AwsError, ImageBuilderArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getVersion: ZIO[Any, AwsError, VersionNumber] =
      AwsError.unwrapOptionField("version", version)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getPlatform: ZIO[Any, AwsError, zio.aws.imagebuilder.model.Platform] =
      AwsError.unwrapOptionField("platform", platform)
    def getSupportedOsVersions: ZIO[Any, AwsError, List[OsVersion]] =
      AwsError.unwrapOptionField("supportedOsVersions", supportedOsVersions)
    def getType: ZIO[Any, AwsError, zio.aws.imagebuilder.model.ComponentType] =
      AwsError.unwrapOptionField("type", `type`)
    def getOwner: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("owner", owner)
    def getDateCreated: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("dateCreated", dateCreated)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.imagebuilder.model.ComponentStatus] =
      AwsError.unwrapOptionField("status", status)
    def getProductCodes: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.ProductCodeListItem.ReadOnly
    ]] = AwsError.unwrapOptionField("productCodes", productCodes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ComponentVersion
  ) extends zio.aws.imagebuilder.model.ComponentVersion.ReadOnly {
    override val arn: Optional[ImageBuilderArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.ImageBuilderArn(value)
      )
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.imagebuilder.model.primitives.ResourceName(value))
    override val version: Optional[VersionNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.imagebuilder.model.primitives.VersionNumber(value))
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val platform: Optional[zio.aws.imagebuilder.model.Platform] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platform())
        .map(value => zio.aws.imagebuilder.model.Platform.wrap(value))
    override val supportedOsVersions: Optional[List[OsVersion]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedOsVersions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.imagebuilder.model.primitives.OsVersion(item)
          }.toList
        )
    override val `type`: Optional[zio.aws.imagebuilder.model.ComponentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.imagebuilder.model.ComponentType.wrap(value))
    override val owner: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.owner())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val dateCreated: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.dateCreated())
      .map(value => zio.aws.imagebuilder.model.primitives.DateTime(value))
    override val status: Optional[zio.aws.imagebuilder.model.ComponentStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.imagebuilder.model.ComponentStatus.wrap(value))
    override val productCodes: Optional[
      List[zio.aws.imagebuilder.model.ProductCodeListItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.productCodes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.ProductCodeListItem.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ComponentVersion
  ): zio.aws.imagebuilder.model.ComponentVersion.ReadOnly = new Wrapper(impl)
}
