package zio.aws.imagebuilder.model
import scala.jdk.CollectionConverters.*
sealed trait ComponentType {
  def unwrap: software.amazon.awssdk.services.imagebuilder.model.ComponentType
}
object ComponentType {
  def wrap(
      value: software.amazon.awssdk.services.imagebuilder.model.ComponentType
  ): zio.aws.imagebuilder.model.ComponentType = value match {
    case software.amazon.awssdk.services.imagebuilder.model.ComponentType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.imagebuilder.model.ComponentType.BUILD =>
      val r = BUILD
      r
    case software.amazon.awssdk.services.imagebuilder.model.ComponentType.TEST =>
      val r = TEST
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.imagebuilder.model.ComponentType {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ComponentType =
      software.amazon.awssdk.services.imagebuilder.model.ComponentType.UNKNOWN_TO_SDK_VERSION
  }
  case object BUILD extends zio.aws.imagebuilder.model.ComponentType {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ComponentType =
      software.amazon.awssdk.services.imagebuilder.model.ComponentType.BUILD
  }
  case object TEST extends zio.aws.imagebuilder.model.ComponentType {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ComponentType =
      software.amazon.awssdk.services.imagebuilder.model.ComponentType.TEST
  }
}
