package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  ImageBuilderArn,
  TagValue,
  DateTime,
  VersionNumber,
  OsVersion,
  NonEmptyString,
  ResourceName,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ComponentSummary(
    arn: Optional[ImageBuilderArn] = Optional.Absent,
    name: Optional[ResourceName] = Optional.Absent,
    version: Optional[VersionNumber] = Optional.Absent,
    platform: Optional[zio.aws.imagebuilder.model.Platform] = Optional.Absent,
    supportedOsVersions: Optional[Iterable[OsVersion]] = Optional.Absent,
    state: Optional[zio.aws.imagebuilder.model.ComponentState] =
      Optional.Absent,
    `type`: Optional[zio.aws.imagebuilder.model.ComponentType] =
      Optional.Absent,
    owner: Optional[NonEmptyString] = Optional.Absent,
    description: Optional[NonEmptyString] = Optional.Absent,
    changeDescription: Optional[NonEmptyString] = Optional.Absent,
    dateCreated: Optional[DateTime] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    publisher: Optional[NonEmptyString] = Optional.Absent,
    obfuscate: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ComponentSummary = {
    import ComponentSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ComponentSummary
      .builder()
      .optionallyWith(
        arn.map(value => ImageBuilderArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        version.map(value => VersionNumber.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .optionallyWith(
        supportedOsVersions.map(value =>
          value.map { item =>
            OsVersion.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.supportedOsVersions)
      .optionallyWith(state.map(value => value.buildAwsValue()))(_.state)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        owner.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.owner)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        changeDescription.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.changeDescription)
      .optionallyWith(
        dateCreated.map(value => DateTime.unwrap(value): java.lang.String)
      )(_.dateCreated)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        publisher.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.publisher)
      .optionallyWith(obfuscate.map(value => value: java.lang.Boolean))(
        _.obfuscate
      )
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.ComponentSummary.ReadOnly =
    zio.aws.imagebuilder.model.ComponentSummary.wrap(buildAwsValue())
}
object ComponentSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ComponentSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ComponentSummary =
      zio.aws.imagebuilder.model.ComponentSummary(
        arn.map(value => value),
        name.map(value => value),
        version.map(value => value),
        platform.map(value => value),
        supportedOsVersions.map(value => value),
        state.map(value => value.asEditable),
        `type`.map(value => value),
        owner.map(value => value),
        description.map(value => value),
        changeDescription.map(value => value),
        dateCreated.map(value => value),
        tags.map(value => value),
        publisher.map(value => value),
        obfuscate.map(value => value)
      )
    def arn: Optional[ImageBuilderArn]
    def name: Optional[ResourceName]
    def version: Optional[VersionNumber]
    def platform: Optional[zio.aws.imagebuilder.model.Platform]
    def supportedOsVersions: Optional[List[OsVersion]]
    def state: Optional[zio.aws.imagebuilder.model.ComponentState.ReadOnly]
    def `type`: Optional[zio.aws.imagebuilder.model.ComponentType]
    def owner: Optional[NonEmptyString]
    def description: Optional[NonEmptyString]
    def changeDescription: Optional[NonEmptyString]
    def dateCreated: Optional[DateTime]
    def tags: Optional[Map[TagKey, TagValue]]
    def publisher: Optional[NonEmptyString]
    def obfuscate: Optional[Boolean]
    def getArn: ZIO[Any, AwsError, ImageBuilderArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getVersion: ZIO[Any, AwsError, VersionNumber] =
      AwsError.unwrapOptionField("version", version)
    def getPlatform: ZIO[Any, AwsError, zio.aws.imagebuilder.model.Platform] =
      AwsError.unwrapOptionField("platform", platform)
    def getSupportedOsVersions: ZIO[Any, AwsError, List[OsVersion]] =
      AwsError.unwrapOptionField("supportedOsVersions", supportedOsVersions)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.ComponentState.ReadOnly
    ] = AwsError.unwrapOptionField("state", state)
    def getType: ZIO[Any, AwsError, zio.aws.imagebuilder.model.ComponentType] =
      AwsError.unwrapOptionField("type", `type`)
    def getOwner: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("owner", owner)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getChangeDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("changeDescription", changeDescription)
    def getDateCreated: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("dateCreated", dateCreated)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getPublisher: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("publisher", publisher)
    def getObfuscate: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("obfuscate", obfuscate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ComponentSummary
  ) extends zio.aws.imagebuilder.model.ComponentSummary.ReadOnly {
    override val arn: Optional[ImageBuilderArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.ImageBuilderArn(value)
      )
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.imagebuilder.model.primitives.ResourceName(value))
    override val version: Optional[VersionNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.imagebuilder.model.primitives.VersionNumber(value))
    override val platform: Optional[zio.aws.imagebuilder.model.Platform] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platform())
        .map(value => zio.aws.imagebuilder.model.Platform.wrap(value))
    override val supportedOsVersions: Optional[List[OsVersion]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedOsVersions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.imagebuilder.model.primitives.OsVersion(item)
          }.toList
        )
    override val state
        : Optional[zio.aws.imagebuilder.model.ComponentState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.imagebuilder.model.ComponentState.wrap(value))
    override val `type`: Optional[zio.aws.imagebuilder.model.ComponentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.imagebuilder.model.ComponentType.wrap(value))
    override val owner: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.owner())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val changeDescription: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.changeDescription())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.NonEmptyString(value)
        )
    override val dateCreated: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.dateCreated())
      .map(value => zio.aws.imagebuilder.model.primitives.DateTime(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.imagebuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.imagebuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val publisher: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.publisher())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val obfuscate: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.obfuscate())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ComponentSummary
  ): zio.aws.imagebuilder.model.ComponentSummary.ReadOnly = new Wrapper(impl)
}
