package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{ClientToken, LifecycleExecutionId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CancelLifecycleExecutionRequest(
    lifecycleExecutionId: LifecycleExecutionId,
    clientToken: ClientToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.CancelLifecycleExecutionRequest = {
    import CancelLifecycleExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.CancelLifecycleExecutionRequest
      .builder()
      .lifecycleExecutionId(
        LifecycleExecutionId.unwrap(lifecycleExecutionId): java.lang.String
      )
      .clientToken(ClientToken.unwrap(clientToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.CancelLifecycleExecutionRequest.ReadOnly =
    zio.aws.imagebuilder.model.CancelLifecycleExecutionRequest
      .wrap(buildAwsValue())
}
object CancelLifecycleExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.CancelLifecycleExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.CancelLifecycleExecutionRequest =
      zio.aws.imagebuilder.model
        .CancelLifecycleExecutionRequest(lifecycleExecutionId, clientToken)
    def lifecycleExecutionId: LifecycleExecutionId
    def clientToken: ClientToken
    def getLifecycleExecutionId: ZIO[Any, Nothing, LifecycleExecutionId] =
      ZIO.succeed(lifecycleExecutionId)
    def getClientToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.CancelLifecycleExecutionRequest
  ) extends zio.aws.imagebuilder.model.CancelLifecycleExecutionRequest.ReadOnly {
    override val lifecycleExecutionId: LifecycleExecutionId =
      zio.aws.imagebuilder.model.primitives
        .LifecycleExecutionId(impl.lifecycleExecutionId())
    override val clientToken: ClientToken =
      zio.aws.imagebuilder.model.primitives.ClientToken(impl.clientToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.CancelLifecycleExecutionRequest
  ): zio.aws.imagebuilder.model.CancelLifecycleExecutionRequest.ReadOnly =
    new Wrapper(impl)
}
