package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.UserDataOverride
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AdditionalInstanceConfiguration(
    systemsManagerAgent: Optional[
      zio.aws.imagebuilder.model.SystemsManagerAgent
    ] = Optional.Absent,
    userDataOverride: Optional[UserDataOverride] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.AdditionalInstanceConfiguration = {
    import AdditionalInstanceConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.AdditionalInstanceConfiguration
      .builder()
      .optionallyWith(systemsManagerAgent.map(value => value.buildAwsValue()))(
        _.systemsManagerAgent
      )
      .optionallyWith(
        userDataOverride.map(value =>
          UserDataOverride.unwrap(value): java.lang.String
        )
      )(_.userDataOverride)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.AdditionalInstanceConfiguration.ReadOnly =
    zio.aws.imagebuilder.model.AdditionalInstanceConfiguration
      .wrap(buildAwsValue())
}
object AdditionalInstanceConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.AdditionalInstanceConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.AdditionalInstanceConfiguration =
      zio.aws.imagebuilder.model.AdditionalInstanceConfiguration(
        systemsManagerAgent.map(value => value.asEditable),
        userDataOverride.map(value => value)
      )
    def systemsManagerAgent
        : Optional[zio.aws.imagebuilder.model.SystemsManagerAgent.ReadOnly]
    def userDataOverride: Optional[UserDataOverride]
    def getSystemsManagerAgent: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.SystemsManagerAgent.ReadOnly
    ] = AwsError.unwrapOptionField("systemsManagerAgent", systemsManagerAgent)
    def getUserDataOverride: ZIO[Any, AwsError, UserDataOverride] =
      AwsError.unwrapOptionField("userDataOverride", userDataOverride)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.AdditionalInstanceConfiguration
  ) extends zio.aws.imagebuilder.model.AdditionalInstanceConfiguration.ReadOnly {
    override val systemsManagerAgent
        : Optional[zio.aws.imagebuilder.model.SystemsManagerAgent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.systemsManagerAgent())
        .map(value =>
          zio.aws.imagebuilder.model.SystemsManagerAgent.wrap(value)
        )
    override val userDataOverride: Optional[UserDataOverride] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userDataOverride())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.UserDataOverride(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.AdditionalInstanceConfiguration
  ): zio.aws.imagebuilder.model.AdditionalInstanceConfiguration.ReadOnly =
    new Wrapper(impl)
}
