package zio.aws.imagebuilder
import zio.aws.imagebuilder.model.UpdateImagePipelineResponse.ReadOnly
import zio.aws.imagebuilder.model.{
  StartResourceStateUpdateRequest,
  ListComponentBuildVersionsRequest,
  PutComponentPolicyRequest,
  CreateInfrastructureConfigurationRequest,
  CreateWorkflowRequest,
  GetInfrastructureConfigurationRequest,
  CreateDistributionConfigurationRequest,
  ImportVmImageRequest,
  GetDistributionConfigurationRequest,
  ListWorkflowBuildVersionsRequest,
  CreateContainerRecipeRequest,
  ListImageScanFindingsRequest,
  ListWorkflowsRequest,
  GetWorkflowStepExecutionRequest,
  DeleteComponentRequest,
  ListLifecycleExecutionResourcesRequest,
  PutImagePolicyRequest,
  DeleteImagePipelineRequest,
  GetLifecycleExecutionRequest,
  ListTagsForResourceRequest,
  GetImageRecipePolicyRequest,
  DeleteImageRequest,
  CreateComponentRequest,
  PutContainerRecipePolicyRequest,
  CreateLifecyclePolicyRequest,
  ListDistributionConfigurationsRequest,
  DeleteDistributionConfigurationRequest,
  ImportComponentRequest,
  SendWorkflowStepActionRequest,
  DeleteContainerRecipeRequest,
  DeleteLifecyclePolicyRequest,
  DeleteImageRecipeRequest,
  CancelLifecycleExecutionRequest,
  GetImageRecipeRequest,
  ListWaitingWorkflowStepsRequest,
  ListImageBuildVersionsRequest,
  GetMarketplaceResourceRequest,
  GetContainerRecipePolicyRequest,
  ListContainerRecipesRequest,
  GetContainerRecipeRequest,
  CancelImageCreationRequest,
  ListWorkflowStepExecutionsRequest,
  ListImageScanFindingAggregationsRequest,
  UpdateImagePipelineRequest,
  UntagResourceRequest,
  PutImageRecipePolicyRequest,
  CreateImageRecipeRequest,
  GetImagePolicyRequest,
  StartImagePipelineExecutionRequest,
  ListComponentsRequest,
  CreateImageRequest,
  ListImagePipelinesRequest,
  GetComponentPolicyRequest,
  ListImagePackagesRequest,
  ListWorkflowExecutionsRequest,
  GetComponentRequest,
  GetImageRequest,
  UpdateInfrastructureConfigurationRequest,
  ListImageRecipesRequest,
  ListInfrastructureConfigurationsRequest,
  GetLifecyclePolicyRequest,
  DeleteInfrastructureConfigurationRequest,
  UpdateDistributionConfigurationRequest,
  DeleteWorkflowRequest,
  GetImagePipelineRequest,
  TagResourceRequest,
  ListImagesRequest,
  ListLifecyclePoliciesRequest,
  UpdateLifecyclePolicyRequest,
  CreateImagePipelineRequest,
  GetWorkflowExecutionRequest,
  ListLifecycleExecutionsRequest,
  ImportDiskImageRequest,
  ListImagePipelineImagesRequest,
  GetWorkflowRequest
}
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.imagebuilder.ImagebuilderAsyncClient
import zio.stream.ZStream
object ImagebuilderMock extends Mock[Imagebuilder] {
  object ListImages
      extends Stream[
        ListImagesRequest,
        AwsError,
        zio.aws.imagebuilder.model.ImageVersion.ReadOnly
      ]
  object ListImagesPaginated
      extends Effect[
        ListImagesRequest,
        AwsError,
        zio.aws.imagebuilder.model.ListImagesResponse.ReadOnly
      ]
  object ListImageRecipes
      extends Stream[
        ListImageRecipesRequest,
        AwsError,
        zio.aws.imagebuilder.model.ImageRecipeSummary.ReadOnly
      ]
  object ListImageRecipesPaginated
      extends Effect[
        ListImageRecipesRequest,
        AwsError,
        zio.aws.imagebuilder.model.ListImageRecipesResponse.ReadOnly
      ]
  object PutComponentPolicy
      extends Effect[
        PutComponentPolicyRequest,
        AwsError,
        zio.aws.imagebuilder.model.PutComponentPolicyResponse.ReadOnly
      ]
  object StartResourceStateUpdate
      extends Effect[
        StartResourceStateUpdateRequest,
        AwsError,
        zio.aws.imagebuilder.model.StartResourceStateUpdateResponse.ReadOnly
      ]
  object ListImageScanFindings
      extends Stream[
        ListImageScanFindingsRequest,
        AwsError,
        zio.aws.imagebuilder.model.ImageScanFinding.ReadOnly
      ]
  object ListImageScanFindingsPaginated
      extends Effect[
        ListImageScanFindingsRequest,
        AwsError,
        zio.aws.imagebuilder.model.ListImageScanFindingsResponse.ReadOnly
      ]
  object ListImageScanFindingAggregations
      extends Stream[
        ListImageScanFindingAggregationsRequest,
        AwsError,
        zio.aws.imagebuilder.model.ImageScanFindingAggregation.ReadOnly
      ]
  object ListImageScanFindingAggregationsPaginated
      extends Effect[
        ListImageScanFindingAggregationsRequest,
        AwsError,
        zio.aws.imagebuilder.model.ListImageScanFindingAggregationsResponse.ReadOnly
      ]
  object GetImageRecipe
      extends Effect[
        GetImageRecipeRequest,
        AwsError,
        zio.aws.imagebuilder.model.GetImageRecipeResponse.ReadOnly
      ]
  object ListImagePackages
      extends Stream[
        ListImagePackagesRequest,
        AwsError,
        zio.aws.imagebuilder.model.ImagePackage.ReadOnly
      ]
  object ListImagePackagesPaginated
      extends Effect[
        ListImagePackagesRequest,
        AwsError,
        zio.aws.imagebuilder.model.ListImagePackagesResponse.ReadOnly
      ]
  object GetComponentPolicy
      extends Effect[
        GetComponentPolicyRequest,
        AwsError,
        zio.aws.imagebuilder.model.GetComponentPolicyResponse.ReadOnly
      ]
  object GetContainerRecipe
      extends Effect[
        GetContainerRecipeRequest,
        AwsError,
        zio.aws.imagebuilder.model.GetContainerRecipeResponse.ReadOnly
      ]
  object StartImagePipelineExecution
      extends Effect[
        StartImagePipelineExecutionRequest,
        AwsError,
        zio.aws.imagebuilder.model.StartImagePipelineExecutionResponse.ReadOnly
      ]
  object UpdateDistributionConfiguration
      extends Effect[
        UpdateDistributionConfigurationRequest,
        AwsError,
        zio.aws.imagebuilder.model.UpdateDistributionConfigurationResponse.ReadOnly
      ]
  object GetWorkflowExecution
      extends Effect[
        GetWorkflowExecutionRequest,
        AwsError,
        zio.aws.imagebuilder.model.GetWorkflowExecutionResponse.ReadOnly
      ]
  object DeleteImage
      extends Effect[
        DeleteImageRequest,
        AwsError,
        zio.aws.imagebuilder.model.DeleteImageResponse.ReadOnly
      ]
  object ListWorkflowStepExecutions
      extends Stream[
        ListWorkflowStepExecutionsRequest,
        AwsError,
        zio.aws.imagebuilder.model.WorkflowStepMetadata.ReadOnly
      ]
  object ListWorkflowStepExecutionsPaginated
      extends Effect[
        ListWorkflowStepExecutionsRequest,
        AwsError,
        zio.aws.imagebuilder.model.ListWorkflowStepExecutionsResponse.ReadOnly
      ]
  object CreateImageRecipe
      extends Effect[
        CreateImageRecipeRequest,
        AwsError,
        zio.aws.imagebuilder.model.CreateImageRecipeResponse.ReadOnly
      ]
  object ListComponentBuildVersions
      extends Stream[
        ListComponentBuildVersionsRequest,
        AwsError,
        zio.aws.imagebuilder.model.ComponentSummary.ReadOnly
      ]
  object ListComponentBuildVersionsPaginated
      extends Effect[
        ListComponentBuildVersionsRequest,
        AwsError,
        zio.aws.imagebuilder.model.ListComponentBuildVersionsResponse.ReadOnly
      ]
  object PutImagePolicy
      extends Effect[
        PutImagePolicyRequest,
        AwsError,
        zio.aws.imagebuilder.model.PutImagePolicyResponse.ReadOnly
      ]
  object GetDistributionConfiguration
      extends Effect[
        GetDistributionConfigurationRequest,
        AwsError,
        zio.aws.imagebuilder.model.GetDistributionConfigurationResponse.ReadOnly
      ]
  object DeleteImageRecipe
      extends Effect[
        DeleteImageRecipeRequest,
        AwsError,
        zio.aws.imagebuilder.model.DeleteImageRecipeResponse.ReadOnly
      ]
  object CreateContainerRecipe
      extends Effect[
        CreateContainerRecipeRequest,
        AwsError,
        zio.aws.imagebuilder.model.CreateContainerRecipeResponse.ReadOnly
      ]
  object DeleteDistributionConfiguration
      extends Effect[
        DeleteDistributionConfigurationRequest,
        AwsError,
        zio.aws.imagebuilder.model.DeleteDistributionConfigurationResponse.ReadOnly
      ]
  object ImportDiskImage
      extends Effect[
        ImportDiskImageRequest,
        AwsError,
        zio.aws.imagebuilder.model.ImportDiskImageResponse.ReadOnly
      ]
  object PutContainerRecipePolicy
      extends Effect[
        PutContainerRecipePolicyRequest,
        AwsError,
        zio.aws.imagebuilder.model.PutContainerRecipePolicyResponse.ReadOnly
      ]
  object CreateInfrastructureConfiguration
      extends Effect[
        CreateInfrastructureConfigurationRequest,
        AwsError,
        zio.aws.imagebuilder.model.CreateInfrastructureConfigurationResponse.ReadOnly
      ]
  object ListComponents
      extends Stream[
        ListComponentsRequest,
        AwsError,
        zio.aws.imagebuilder.model.ComponentVersion.ReadOnly
      ]
  object ListComponentsPaginated
      extends Effect[
        ListComponentsRequest,
        AwsError,
        zio.aws.imagebuilder.model.ListComponentsResponse.ReadOnly
      ]
  object SendWorkflowStepAction
      extends Effect[
        SendWorkflowStepActionRequest,
        AwsError,
        zio.aws.imagebuilder.model.SendWorkflowStepActionResponse.ReadOnly
      ]
  object CreateImage
      extends Effect[
        CreateImageRequest,
        AwsError,
        zio.aws.imagebuilder.model.CreateImageResponse.ReadOnly
      ]
  object DeleteLifecyclePolicy
      extends Effect[
        DeleteLifecyclePolicyRequest,
        AwsError,
        zio.aws.imagebuilder.model.DeleteLifecyclePolicyResponse.ReadOnly
      ]
  object DeleteInfrastructureConfiguration
      extends Effect[
        DeleteInfrastructureConfigurationRequest,
        AwsError,
        zio.aws.imagebuilder.model.DeleteInfrastructureConfigurationResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.imagebuilder.model.UntagResourceResponse.ReadOnly
      ]
  object ListLifecycleExecutions
      extends Stream[
        ListLifecycleExecutionsRequest,
        AwsError,
        zio.aws.imagebuilder.model.LifecycleExecution.ReadOnly
      ]
  object ListLifecycleExecutionsPaginated
      extends Effect[
        ListLifecycleExecutionsRequest,
        AwsError,
        zio.aws.imagebuilder.model.ListLifecycleExecutionsResponse.ReadOnly
      ]
  object GetLifecycleExecution
      extends Effect[
        GetLifecycleExecutionRequest,
        AwsError,
        zio.aws.imagebuilder.model.GetLifecycleExecutionResponse.ReadOnly
      ]
  object DeleteComponent
      extends Effect[
        DeleteComponentRequest,
        AwsError,
        zio.aws.imagebuilder.model.DeleteComponentResponse.ReadOnly
      ]
  object ListImagePipelines
      extends Stream[
        ListImagePipelinesRequest,
        AwsError,
        zio.aws.imagebuilder.model.ImagePipeline.ReadOnly
      ]
  object ListImagePipelinesPaginated
      extends Effect[
        ListImagePipelinesRequest,
        AwsError,
        zio.aws.imagebuilder.model.ListImagePipelinesResponse.ReadOnly
      ]
  object ListDistributionConfigurations
      extends Stream[
        ListDistributionConfigurationsRequest,
        AwsError,
        zio.aws.imagebuilder.model.DistributionConfigurationSummary.ReadOnly
      ]
  object ListDistributionConfigurationsPaginated
      extends Effect[
        ListDistributionConfigurationsRequest,
        AwsError,
        zio.aws.imagebuilder.model.ListDistributionConfigurationsResponse.ReadOnly
      ]
  object GetContainerRecipePolicy
      extends Effect[
        GetContainerRecipePolicyRequest,
        AwsError,
        zio.aws.imagebuilder.model.GetContainerRecipePolicyResponse.ReadOnly
      ]
  object ListWaitingWorkflowSteps
      extends Stream[
        ListWaitingWorkflowStepsRequest,
        AwsError,
        zio.aws.imagebuilder.model.WorkflowStepExecution.ReadOnly
      ]
  object ListWaitingWorkflowStepsPaginated
      extends Effect[
        ListWaitingWorkflowStepsRequest,
        AwsError,
        zio.aws.imagebuilder.model.ListWaitingWorkflowStepsResponse.ReadOnly
      ]
  object GetWorkflow
      extends Effect[
        GetWorkflowRequest,
        AwsError,
        zio.aws.imagebuilder.model.GetWorkflowResponse.ReadOnly
      ]
  object ListImagePipelineImages
      extends Stream[
        ListImagePipelineImagesRequest,
        AwsError,
        zio.aws.imagebuilder.model.ImageSummary.ReadOnly
      ]
  object ListImagePipelineImagesPaginated
      extends Effect[
        ListImagePipelineImagesRequest,
        AwsError,
        zio.aws.imagebuilder.model.ListImagePipelineImagesResponse.ReadOnly
      ]
  object CreateDistributionConfiguration
      extends Effect[
        CreateDistributionConfigurationRequest,
        AwsError,
        zio.aws.imagebuilder.model.CreateDistributionConfigurationResponse.ReadOnly
      ]
  object ImportComponent
      extends Effect[
        ImportComponentRequest,
        AwsError,
        zio.aws.imagebuilder.model.ImportComponentResponse.ReadOnly
      ]
  object CreateComponent
      extends Effect[
        CreateComponentRequest,
        AwsError,
        zio.aws.imagebuilder.model.CreateComponentResponse.ReadOnly
      ]
  object GetImagePipeline
      extends Effect[
        GetImagePipelineRequest,
        AwsError,
        zio.aws.imagebuilder.model.GetImagePipelineResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.imagebuilder.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.imagebuilder.model.TagResourceResponse.ReadOnly
      ]
  object ListWorkflowExecutions
      extends Stream[
        ListWorkflowExecutionsRequest,
        AwsError,
        zio.aws.imagebuilder.model.WorkflowExecutionMetadata.ReadOnly
      ]
  object ListWorkflowExecutionsPaginated
      extends Effect[
        ListWorkflowExecutionsRequest,
        AwsError,
        zio.aws.imagebuilder.model.ListWorkflowExecutionsResponse.ReadOnly
      ]
  object CreateImagePipeline
      extends Effect[
        CreateImagePipelineRequest,
        AwsError,
        zio.aws.imagebuilder.model.CreateImagePipelineResponse.ReadOnly
      ]
  object ListInfrastructureConfigurations
      extends Stream[
        ListInfrastructureConfigurationsRequest,
        AwsError,
        zio.aws.imagebuilder.model.InfrastructureConfigurationSummary.ReadOnly
      ]
  object ListInfrastructureConfigurationsPaginated
      extends Effect[
        ListInfrastructureConfigurationsRequest,
        AwsError,
        zio.aws.imagebuilder.model.ListInfrastructureConfigurationsResponse.ReadOnly
      ]
  object ListWorkflowBuildVersions
      extends Stream[
        ListWorkflowBuildVersionsRequest,
        AwsError,
        zio.aws.imagebuilder.model.WorkflowSummary.ReadOnly
      ]
  object ListWorkflowBuildVersionsPaginated
      extends Effect[
        ListWorkflowBuildVersionsRequest,
        AwsError,
        zio.aws.imagebuilder.model.ListWorkflowBuildVersionsResponse.ReadOnly
      ]
  object ListWorkflows
      extends Stream[
        ListWorkflowsRequest,
        AwsError,
        zio.aws.imagebuilder.model.WorkflowVersion.ReadOnly
      ]
  object ListWorkflowsPaginated
      extends Effect[
        ListWorkflowsRequest,
        AwsError,
        zio.aws.imagebuilder.model.ListWorkflowsResponse.ReadOnly
      ]
  object GetInfrastructureConfiguration
      extends Effect[
        GetInfrastructureConfigurationRequest,
        AwsError,
        zio.aws.imagebuilder.model.GetInfrastructureConfigurationResponse.ReadOnly
      ]
  object DeleteContainerRecipe
      extends Effect[
        DeleteContainerRecipeRequest,
        AwsError,
        zio.aws.imagebuilder.model.DeleteContainerRecipeResponse.ReadOnly
      ]
  object GetImage
      extends Effect[
        GetImageRequest,
        AwsError,
        zio.aws.imagebuilder.model.GetImageResponse.ReadOnly
      ]
  object ListLifecyclePolicies
      extends Stream[
        ListLifecyclePoliciesRequest,
        AwsError,
        zio.aws.imagebuilder.model.LifecyclePolicySummary.ReadOnly
      ]
  object ListLifecyclePoliciesPaginated
      extends Effect[
        ListLifecyclePoliciesRequest,
        AwsError,
        zio.aws.imagebuilder.model.ListLifecyclePoliciesResponse.ReadOnly
      ]
  object CreateLifecyclePolicy
      extends Effect[
        CreateLifecyclePolicyRequest,
        AwsError,
        zio.aws.imagebuilder.model.CreateLifecyclePolicyResponse.ReadOnly
      ]
  object ListContainerRecipes
      extends Stream[
        ListContainerRecipesRequest,
        AwsError,
        zio.aws.imagebuilder.model.ContainerRecipeSummary.ReadOnly
      ]
  object ListContainerRecipesPaginated
      extends Effect[
        ListContainerRecipesRequest,
        AwsError,
        zio.aws.imagebuilder.model.ListContainerRecipesResponse.ReadOnly
      ]
  object CancelLifecycleExecution
      extends Effect[
        CancelLifecycleExecutionRequest,
        AwsError,
        zio.aws.imagebuilder.model.CancelLifecycleExecutionResponse.ReadOnly
      ]
  object DeleteImagePipeline
      extends Effect[
        DeleteImagePipelineRequest,
        AwsError,
        zio.aws.imagebuilder.model.DeleteImagePipelineResponse.ReadOnly
      ]
  object PutImageRecipePolicy
      extends Effect[
        PutImageRecipePolicyRequest,
        AwsError,
        zio.aws.imagebuilder.model.PutImageRecipePolicyResponse.ReadOnly
      ]
  object UpdateImagePipeline
      extends Effect[UpdateImagePipelineRequest, AwsError, ReadOnly]
  object DeleteWorkflow
      extends Effect[
        DeleteWorkflowRequest,
        AwsError,
        zio.aws.imagebuilder.model.DeleteWorkflowResponse.ReadOnly
      ]
  object GetMarketplaceResource
      extends Effect[
        GetMarketplaceResourceRequest,
        AwsError,
        zio.aws.imagebuilder.model.GetMarketplaceResourceResponse.ReadOnly
      ]
  object GetImageRecipePolicy
      extends Effect[
        GetImageRecipePolicyRequest,
        AwsError,
        zio.aws.imagebuilder.model.GetImageRecipePolicyResponse.ReadOnly
      ]
  object ListImageBuildVersions
      extends Stream[
        ListImageBuildVersionsRequest,
        AwsError,
        zio.aws.imagebuilder.model.ImageSummary.ReadOnly
      ]
  object ListImageBuildVersionsPaginated
      extends Effect[
        ListImageBuildVersionsRequest,
        AwsError,
        zio.aws.imagebuilder.model.ListImageBuildVersionsResponse.ReadOnly
      ]
  object UpdateInfrastructureConfiguration
      extends Effect[
        UpdateInfrastructureConfigurationRequest,
        AwsError,
        zio.aws.imagebuilder.model.UpdateInfrastructureConfigurationResponse.ReadOnly
      ]
  object GetComponent
      extends Effect[
        GetComponentRequest,
        AwsError,
        zio.aws.imagebuilder.model.GetComponentResponse.ReadOnly
      ]
  object ListLifecycleExecutionResources
      extends Stream[
        ListLifecycleExecutionResourcesRequest,
        AwsError,
        zio.aws.imagebuilder.model.LifecycleExecutionResource.ReadOnly
      ]
  object ListLifecycleExecutionResourcesPaginated
      extends Effect[
        ListLifecycleExecutionResourcesRequest,
        AwsError,
        zio.aws.imagebuilder.model.ListLifecycleExecutionResourcesResponse.ReadOnly
      ]
  object GetWorkflowStepExecution
      extends Effect[
        GetWorkflowStepExecutionRequest,
        AwsError,
        zio.aws.imagebuilder.model.GetWorkflowStepExecutionResponse.ReadOnly
      ]
  object GetLifecyclePolicy
      extends Effect[
        GetLifecyclePolicyRequest,
        AwsError,
        zio.aws.imagebuilder.model.GetLifecyclePolicyResponse.ReadOnly
      ]
  object CreateWorkflow
      extends Effect[
        CreateWorkflowRequest,
        AwsError,
        zio.aws.imagebuilder.model.CreateWorkflowResponse.ReadOnly
      ]
  object UpdateLifecyclePolicy
      extends Effect[
        UpdateLifecyclePolicyRequest,
        AwsError,
        zio.aws.imagebuilder.model.UpdateLifecyclePolicyResponse.ReadOnly
      ]
  object ImportVmImage
      extends Effect[
        ImportVmImageRequest,
        AwsError,
        zio.aws.imagebuilder.model.ImportVmImageResponse.ReadOnly
      ]
  object CancelImageCreation
      extends Effect[
        CancelImageCreationRequest,
        AwsError,
        zio.aws.imagebuilder.model.CancelImageCreationResponse.ReadOnly
      ]
  object GetImagePolicy
      extends Effect[
        GetImagePolicyRequest,
        AwsError,
        zio.aws.imagebuilder.model.GetImagePolicyResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Imagebuilder] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Imagebuilder] { rts =>
        zio.ZIO.succeed {
          new Imagebuilder {
            val api: ImagebuilderAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Imagebuilder = this
            def listImages(request: ListImagesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.imagebuilder.model.ImageVersion.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListImages, request)
                }
                .getOrThrowFiberFailure()
            }
            def listImagesPaginated(request: ListImagesRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.ListImagesResponse.ReadOnly
            ] = proxy(ListImagesPaginated, request)
            def listImageRecipes(request: ListImageRecipesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.imagebuilder.model.ImageRecipeSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListImageRecipes, request)
                }
                .getOrThrowFiberFailure()
            }
            def listImageRecipesPaginated(request: ListImageRecipesRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.ListImageRecipesResponse.ReadOnly
            ] = proxy(ListImageRecipesPaginated, request)
            def putComponentPolicy(request: PutComponentPolicyRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.PutComponentPolicyResponse.ReadOnly
            ] = proxy(PutComponentPolicy, request)
            def startResourceStateUpdate(
                request: StartResourceStateUpdateRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.StartResourceStateUpdateResponse.ReadOnly
            ] = proxy(StartResourceStateUpdate, request)
            def listImageScanFindings(
                request: ListImageScanFindingsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.imagebuilder.model.ImageScanFinding.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListImageScanFindings, request)
                }
                .getOrThrowFiberFailure()
            }
            def listImageScanFindingsPaginated(
                request: ListImageScanFindingsRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.ListImageScanFindingsResponse.ReadOnly
            ] = proxy(ListImageScanFindingsPaginated, request)
            def listImageScanFindingAggregations(
                request: ListImageScanFindingAggregationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.imagebuilder.model.ImageScanFindingAggregation.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListImageScanFindingAggregations, request)
                }
                .getOrThrowFiberFailure()
            }
            def listImageScanFindingAggregationsPaginated(
                request: ListImageScanFindingAggregationsRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.ListImageScanFindingAggregationsResponse.ReadOnly
            ] = proxy(ListImageScanFindingAggregationsPaginated, request)
            def getImageRecipe(request: GetImageRecipeRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.GetImageRecipeResponse.ReadOnly
            ] = proxy(GetImageRecipe, request)
            def listImagePackages(request: ListImagePackagesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.imagebuilder.model.ImagePackage.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListImagePackages, request)
                }
                .getOrThrowFiberFailure()
            }
            def listImagePackagesPaginated(
                request: ListImagePackagesRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.ListImagePackagesResponse.ReadOnly
            ] = proxy(ListImagePackagesPaginated, request)
            def getComponentPolicy(request: GetComponentPolicyRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.GetComponentPolicyResponse.ReadOnly
            ] = proxy(GetComponentPolicy, request)
            def getContainerRecipe(request: GetContainerRecipeRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.GetContainerRecipeResponse.ReadOnly
            ] = proxy(GetContainerRecipe, request)
            def startImagePipelineExecution(
                request: StartImagePipelineExecutionRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.StartImagePipelineExecutionResponse.ReadOnly
            ] = proxy(StartImagePipelineExecution, request)
            def updateDistributionConfiguration(
                request: UpdateDistributionConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.UpdateDistributionConfigurationResponse.ReadOnly
            ] = proxy(UpdateDistributionConfiguration, request)
            def getWorkflowExecution(request: GetWorkflowExecutionRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.GetWorkflowExecutionResponse.ReadOnly
            ] = proxy(GetWorkflowExecution, request)
            def deleteImage(request: DeleteImageRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.DeleteImageResponse.ReadOnly
            ] = proxy(DeleteImage, request)
            def listWorkflowStepExecutions(
                request: ListWorkflowStepExecutionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.imagebuilder.model.WorkflowStepMetadata.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListWorkflowStepExecutions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listWorkflowStepExecutionsPaginated(
                request: ListWorkflowStepExecutionsRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.ListWorkflowStepExecutionsResponse.ReadOnly
            ] = proxy(ListWorkflowStepExecutionsPaginated, request)
            def createImageRecipe(request: CreateImageRecipeRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.CreateImageRecipeResponse.ReadOnly
            ] = proxy(CreateImageRecipe, request)
            def listComponentBuildVersions(
                request: ListComponentBuildVersionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.imagebuilder.model.ComponentSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListComponentBuildVersions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listComponentBuildVersionsPaginated(
                request: ListComponentBuildVersionsRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.ListComponentBuildVersionsResponse.ReadOnly
            ] = proxy(ListComponentBuildVersionsPaginated, request)
            def putImagePolicy(request: PutImagePolicyRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.PutImagePolicyResponse.ReadOnly
            ] = proxy(PutImagePolicy, request)
            def getDistributionConfiguration(
                request: GetDistributionConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.GetDistributionConfigurationResponse.ReadOnly
            ] = proxy(GetDistributionConfiguration, request)
            def deleteImageRecipe(request: DeleteImageRecipeRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.DeleteImageRecipeResponse.ReadOnly
            ] = proxy(DeleteImageRecipe, request)
            def createContainerRecipe(
                request: CreateContainerRecipeRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.CreateContainerRecipeResponse.ReadOnly
            ] = proxy(CreateContainerRecipe, request)
            def deleteDistributionConfiguration(
                request: DeleteDistributionConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.DeleteDistributionConfigurationResponse.ReadOnly
            ] = proxy(DeleteDistributionConfiguration, request)
            def importDiskImage(request: ImportDiskImageRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.ImportDiskImageResponse.ReadOnly
            ] = proxy(ImportDiskImage, request)
            def putContainerRecipePolicy(
                request: PutContainerRecipePolicyRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.PutContainerRecipePolicyResponse.ReadOnly
            ] = proxy(PutContainerRecipePolicy, request)
            def createInfrastructureConfiguration(
                request: CreateInfrastructureConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.CreateInfrastructureConfigurationResponse.ReadOnly
            ] = proxy(CreateInfrastructureConfiguration, request)
            def listComponents(request: ListComponentsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.imagebuilder.model.ComponentVersion.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListComponents, request)
                }
                .getOrThrowFiberFailure()
            }
            def listComponentsPaginated(request: ListComponentsRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.ListComponentsResponse.ReadOnly
            ] = proxy(ListComponentsPaginated, request)
            def sendWorkflowStepAction(
                request: SendWorkflowStepActionRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.SendWorkflowStepActionResponse.ReadOnly
            ] = proxy(SendWorkflowStepAction, request)
            def createImage(request: CreateImageRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.CreateImageResponse.ReadOnly
            ] = proxy(CreateImage, request)
            def deleteLifecyclePolicy(
                request: DeleteLifecyclePolicyRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.DeleteLifecyclePolicyResponse.ReadOnly
            ] = proxy(DeleteLifecyclePolicy, request)
            def deleteInfrastructureConfiguration(
                request: DeleteInfrastructureConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.DeleteInfrastructureConfigurationResponse.ReadOnly
            ] = proxy(DeleteInfrastructureConfiguration, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def listLifecycleExecutions(
                request: ListLifecycleExecutionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.imagebuilder.model.LifecycleExecution.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListLifecycleExecutions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listLifecycleExecutionsPaginated(
                request: ListLifecycleExecutionsRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.ListLifecycleExecutionsResponse.ReadOnly
            ] = proxy(ListLifecycleExecutionsPaginated, request)
            def getLifecycleExecution(
                request: GetLifecycleExecutionRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.GetLifecycleExecutionResponse.ReadOnly
            ] = proxy(GetLifecycleExecution, request)
            def deleteComponent(request: DeleteComponentRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.DeleteComponentResponse.ReadOnly
            ] = proxy(DeleteComponent, request)
            def listImagePipelines(request: ListImagePipelinesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.imagebuilder.model.ImagePipeline.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListImagePipelines, request)
                }
                .getOrThrowFiberFailure()
            }
            def listImagePipelinesPaginated(
                request: ListImagePipelinesRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.ListImagePipelinesResponse.ReadOnly
            ] = proxy(ListImagePipelinesPaginated, request)
            def listDistributionConfigurations(
                request: ListDistributionConfigurationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.imagebuilder.model.DistributionConfigurationSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDistributionConfigurations, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDistributionConfigurationsPaginated(
                request: ListDistributionConfigurationsRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.ListDistributionConfigurationsResponse.ReadOnly
            ] = proxy(ListDistributionConfigurationsPaginated, request)
            def getContainerRecipePolicy(
                request: GetContainerRecipePolicyRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.GetContainerRecipePolicyResponse.ReadOnly
            ] = proxy(GetContainerRecipePolicy, request)
            def listWaitingWorkflowSteps(
                request: ListWaitingWorkflowStepsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.imagebuilder.model.WorkflowStepExecution.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListWaitingWorkflowSteps, request)
                }
                .getOrThrowFiberFailure()
            }
            def listWaitingWorkflowStepsPaginated(
                request: ListWaitingWorkflowStepsRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.ListWaitingWorkflowStepsResponse.ReadOnly
            ] = proxy(ListWaitingWorkflowStepsPaginated, request)
            def getWorkflow(request: GetWorkflowRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.GetWorkflowResponse.ReadOnly
            ] = proxy(GetWorkflow, request)
            def listImagePipelineImages(
                request: ListImagePipelineImagesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.imagebuilder.model.ImageSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListImagePipelineImages, request)
                }
                .getOrThrowFiberFailure()
            }
            def listImagePipelineImagesPaginated(
                request: ListImagePipelineImagesRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.ListImagePipelineImagesResponse.ReadOnly
            ] = proxy(ListImagePipelineImagesPaginated, request)
            def createDistributionConfiguration(
                request: CreateDistributionConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.CreateDistributionConfigurationResponse.ReadOnly
            ] = proxy(CreateDistributionConfiguration, request)
            def importComponent(request: ImportComponentRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.ImportComponentResponse.ReadOnly
            ] = proxy(ImportComponent, request)
            def createComponent(request: CreateComponentRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.CreateComponentResponse.ReadOnly
            ] = proxy(CreateComponent, request)
            def getImagePipeline(request: GetImagePipelineRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.GetImagePipelineResponse.ReadOnly
            ] = proxy(GetImagePipeline, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def listWorkflowExecutions(
                request: ListWorkflowExecutionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.imagebuilder.model.WorkflowExecutionMetadata.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListWorkflowExecutions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listWorkflowExecutionsPaginated(
                request: ListWorkflowExecutionsRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.ListWorkflowExecutionsResponse.ReadOnly
            ] = proxy(ListWorkflowExecutionsPaginated, request)
            def createImagePipeline(request: CreateImagePipelineRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.CreateImagePipelineResponse.ReadOnly
            ] = proxy(CreateImagePipeline, request)
            def listInfrastructureConfigurations(
                request: ListInfrastructureConfigurationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.imagebuilder.model.InfrastructureConfigurationSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListInfrastructureConfigurations, request)
                }
                .getOrThrowFiberFailure()
            }
            def listInfrastructureConfigurationsPaginated(
                request: ListInfrastructureConfigurationsRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.ListInfrastructureConfigurationsResponse.ReadOnly
            ] = proxy(ListInfrastructureConfigurationsPaginated, request)
            def listWorkflowBuildVersions(
                request: ListWorkflowBuildVersionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.imagebuilder.model.WorkflowSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListWorkflowBuildVersions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listWorkflowBuildVersionsPaginated(
                request: ListWorkflowBuildVersionsRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.ListWorkflowBuildVersionsResponse.ReadOnly
            ] = proxy(ListWorkflowBuildVersionsPaginated, request)
            def listWorkflows(request: ListWorkflowsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.imagebuilder.model.WorkflowVersion.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListWorkflows, request)
                }
                .getOrThrowFiberFailure()
            }
            def listWorkflowsPaginated(request: ListWorkflowsRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.ListWorkflowsResponse.ReadOnly
            ] = proxy(ListWorkflowsPaginated, request)
            def getInfrastructureConfiguration(
                request: GetInfrastructureConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.GetInfrastructureConfigurationResponse.ReadOnly
            ] = proxy(GetInfrastructureConfiguration, request)
            def deleteContainerRecipe(
                request: DeleteContainerRecipeRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.DeleteContainerRecipeResponse.ReadOnly
            ] = proxy(DeleteContainerRecipe, request)
            def getImage(request: GetImageRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.GetImageResponse.ReadOnly
            ] = proxy(GetImage, request)
            def listLifecyclePolicies(
                request: ListLifecyclePoliciesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.imagebuilder.model.LifecyclePolicySummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListLifecyclePolicies, request)
                }
                .getOrThrowFiberFailure()
            }
            def listLifecyclePoliciesPaginated(
                request: ListLifecyclePoliciesRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.ListLifecyclePoliciesResponse.ReadOnly
            ] = proxy(ListLifecyclePoliciesPaginated, request)
            def createLifecyclePolicy(
                request: CreateLifecyclePolicyRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.CreateLifecyclePolicyResponse.ReadOnly
            ] = proxy(CreateLifecyclePolicy, request)
            def listContainerRecipes(
                request: ListContainerRecipesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.imagebuilder.model.ContainerRecipeSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListContainerRecipes, request)
                }
                .getOrThrowFiberFailure()
            }
            def listContainerRecipesPaginated(
                request: ListContainerRecipesRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.ListContainerRecipesResponse.ReadOnly
            ] = proxy(ListContainerRecipesPaginated, request)
            def cancelLifecycleExecution(
                request: CancelLifecycleExecutionRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.CancelLifecycleExecutionResponse.ReadOnly
            ] = proxy(CancelLifecycleExecution, request)
            def deleteImagePipeline(request: DeleteImagePipelineRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.DeleteImagePipelineResponse.ReadOnly
            ] = proxy(DeleteImagePipeline, request)
            def putImageRecipePolicy(request: PutImageRecipePolicyRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.PutImageRecipePolicyResponse.ReadOnly
            ] = proxy(PutImageRecipePolicy, request)
            def updateImagePipeline(
                request: UpdateImagePipelineRequest
            ): IO[AwsError, ReadOnly] = proxy(UpdateImagePipeline, request)
            def deleteWorkflow(request: DeleteWorkflowRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.DeleteWorkflowResponse.ReadOnly
            ] = proxy(DeleteWorkflow, request)
            def getMarketplaceResource(
                request: GetMarketplaceResourceRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.GetMarketplaceResourceResponse.ReadOnly
            ] = proxy(GetMarketplaceResource, request)
            def getImageRecipePolicy(request: GetImageRecipePolicyRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.GetImageRecipePolicyResponse.ReadOnly
            ] = proxy(GetImageRecipePolicy, request)
            def listImageBuildVersions(
                request: ListImageBuildVersionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.imagebuilder.model.ImageSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListImageBuildVersions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listImageBuildVersionsPaginated(
                request: ListImageBuildVersionsRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.ListImageBuildVersionsResponse.ReadOnly
            ] = proxy(ListImageBuildVersionsPaginated, request)
            def updateInfrastructureConfiguration(
                request: UpdateInfrastructureConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.UpdateInfrastructureConfigurationResponse.ReadOnly
            ] = proxy(UpdateInfrastructureConfiguration, request)
            def getComponent(request: GetComponentRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.GetComponentResponse.ReadOnly
            ] = proxy(GetComponent, request)
            def listLifecycleExecutionResources(
                request: ListLifecycleExecutionResourcesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.imagebuilder.model.LifecycleExecutionResource.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListLifecycleExecutionResources, request)
                }
                .getOrThrowFiberFailure()
            }
            def listLifecycleExecutionResourcesPaginated(
                request: ListLifecycleExecutionResourcesRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.ListLifecycleExecutionResourcesResponse.ReadOnly
            ] = proxy(ListLifecycleExecutionResourcesPaginated, request)
            def getWorkflowStepExecution(
                request: GetWorkflowStepExecutionRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.GetWorkflowStepExecutionResponse.ReadOnly
            ] = proxy(GetWorkflowStepExecution, request)
            def getLifecyclePolicy(request: GetLifecyclePolicyRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.GetLifecyclePolicyResponse.ReadOnly
            ] = proxy(GetLifecyclePolicy, request)
            def createWorkflow(request: CreateWorkflowRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.CreateWorkflowResponse.ReadOnly
            ] = proxy(CreateWorkflow, request)
            def updateLifecyclePolicy(
                request: UpdateLifecyclePolicyRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.UpdateLifecyclePolicyResponse.ReadOnly
            ] = proxy(UpdateLifecyclePolicy, request)
            def importVmImage(request: ImportVmImageRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.ImportVmImageResponse.ReadOnly
            ] = proxy(ImportVmImage, request)
            def cancelImageCreation(request: CancelImageCreationRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.CancelImageCreationResponse.ReadOnly
            ] = proxy(CancelImageCreation, request)
            def getImagePolicy(request: GetImagePolicyRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.GetImagePolicyResponse.ReadOnly
            ] = proxy(GetImagePolicy, request)
          }
        }
      }
    }
  }
}
