package zio.aws.imagebuilder.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.imagebuilder.model.primitives.{
  WorkflowExecutionId,
  PaginationToken,
  RestrictedInteger
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListWorkflowStepExecutionsRequest(
    maxResults: Optional[RestrictedInteger] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    workflowExecutionId: WorkflowExecutionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ListWorkflowStepExecutionsRequest = {
    import ListWorkflowStepExecutionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ListWorkflowStepExecutionsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => RestrictedInteger.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .workflowExecutionId(
        WorkflowExecutionId.unwrap(workflowExecutionId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.ListWorkflowStepExecutionsRequest.ReadOnly =
    zio.aws.imagebuilder.model.ListWorkflowStepExecutionsRequest
      .wrap(buildAwsValue())
}
object ListWorkflowStepExecutionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ListWorkflowStepExecutionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.ListWorkflowStepExecutionsRequest =
      zio.aws.imagebuilder.model.ListWorkflowStepExecutionsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        workflowExecutionId
      )
    def maxResults: Optional[RestrictedInteger]
    def nextToken: Optional[PaginationToken]
    def workflowExecutionId: WorkflowExecutionId
    def getMaxResults: ZIO[Any, AwsError, RestrictedInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getWorkflowExecutionId: ZIO[Any, Nothing, WorkflowExecutionId] =
      ZIO.succeed(workflowExecutionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListWorkflowStepExecutionsRequest
  ) extends zio.aws.imagebuilder.model.ListWorkflowStepExecutionsRequest.ReadOnly {
    override val maxResults: Optional[RestrictedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.RestrictedInteger(value)
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.PaginationToken(value)
      )
    override val workflowExecutionId: WorkflowExecutionId =
      zio.aws.imagebuilder.model.primitives
        .WorkflowExecutionId(impl.workflowExecutionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListWorkflowStepExecutionsRequest
  ): zio.aws.imagebuilder.model.ListWorkflowStepExecutionsRequest.ReadOnly =
    new Wrapper(impl)
}
