package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetImagePipelineResponse(
    requestId: Optional[NonEmptyString] = Optional.Absent,
    imagePipeline: Optional[zio.aws.imagebuilder.model.ImagePipeline] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.GetImagePipelineResponse = {
    import GetImagePipelineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.GetImagePipelineResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(imagePipeline.map(value => value.buildAwsValue()))(
        _.imagePipeline
      )
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.GetImagePipelineResponse.ReadOnly =
    zio.aws.imagebuilder.model.GetImagePipelineResponse.wrap(buildAwsValue())
}
object GetImagePipelineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.GetImagePipelineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.GetImagePipelineResponse =
      zio.aws.imagebuilder.model.GetImagePipelineResponse(
        requestId.map(value => value),
        imagePipeline.map(value => value.asEditable)
      )
    def requestId: Optional[NonEmptyString]
    def imagePipeline
        : Optional[zio.aws.imagebuilder.model.ImagePipeline.ReadOnly]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getImagePipeline: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.ImagePipeline.ReadOnly
    ] = AwsError.unwrapOptionField("imagePipeline", imagePipeline)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.GetImagePipelineResponse
  ) extends zio.aws.imagebuilder.model.GetImagePipelineResponse.ReadOnly {
    override val requestId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val imagePipeline
        : Optional[zio.aws.imagebuilder.model.ImagePipeline.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imagePipeline())
        .map(value => zio.aws.imagebuilder.model.ImagePipeline.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.GetImagePipelineResponse
  ): zio.aws.imagebuilder.model.GetImagePipelineResponse.ReadOnly = new Wrapper(
    impl
  )
}
