package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  WorkflowExecutionId,
  ImageBuildVersionArn,
  PaginationToken,
  WorkflowBuildVersionArn,
  ImageBuildMessage,
  NonEmptyString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListWorkflowStepExecutionsResponse(
    requestId: Optional[NonEmptyString] = Optional.Absent,
    steps: Optional[Iterable[zio.aws.imagebuilder.model.WorkflowStepMetadata]] =
      Optional.Absent,
    workflowBuildVersionArn: Optional[WorkflowBuildVersionArn] =
      Optional.Absent,
    workflowExecutionId: Optional[WorkflowExecutionId] = Optional.Absent,
    imageBuildVersionArn: Optional[ImageBuildVersionArn] = Optional.Absent,
    message: Optional[ImageBuildMessage] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ListWorkflowStepExecutionsResponse = {
    import ListWorkflowStepExecutionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ListWorkflowStepExecutionsResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        steps.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.steps)
      .optionallyWith(
        workflowBuildVersionArn.map(value =>
          WorkflowBuildVersionArn.unwrap(value): java.lang.String
        )
      )(_.workflowBuildVersionArn)
      .optionallyWith(
        workflowExecutionId.map(value =>
          WorkflowExecutionId.unwrap(value): java.lang.String
        )
      )(_.workflowExecutionId)
      .optionallyWith(
        imageBuildVersionArn.map(value =>
          ImageBuildVersionArn.unwrap(value): java.lang.String
        )
      )(_.imageBuildVersionArn)
      .optionallyWith(
        message.map(value => ImageBuildMessage.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.ListWorkflowStepExecutionsResponse.ReadOnly =
    zio.aws.imagebuilder.model.ListWorkflowStepExecutionsResponse
      .wrap(buildAwsValue())
}
object ListWorkflowStepExecutionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ListWorkflowStepExecutionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.ListWorkflowStepExecutionsResponse =
      zio.aws.imagebuilder.model.ListWorkflowStepExecutionsResponse(
        requestId.map(value => value),
        steps.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        workflowBuildVersionArn.map(value => value),
        workflowExecutionId.map(value => value),
        imageBuildVersionArn.map(value => value),
        message.map(value => value),
        nextToken.map(value => value)
      )
    def requestId: Optional[NonEmptyString]
    def steps: Optional[
      List[zio.aws.imagebuilder.model.WorkflowStepMetadata.ReadOnly]
    ]
    def workflowBuildVersionArn: Optional[WorkflowBuildVersionArn]
    def workflowExecutionId: Optional[WorkflowExecutionId]
    def imageBuildVersionArn: Optional[ImageBuildVersionArn]
    def message: Optional[ImageBuildMessage]
    def nextToken: Optional[PaginationToken]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getSteps: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.WorkflowStepMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("steps", steps)
    def getWorkflowBuildVersionArn
        : ZIO[Any, AwsError, WorkflowBuildVersionArn] = AwsError
      .unwrapOptionField("workflowBuildVersionArn", workflowBuildVersionArn)
    def getWorkflowExecutionId: ZIO[Any, AwsError, WorkflowExecutionId] =
      AwsError.unwrapOptionField("workflowExecutionId", workflowExecutionId)
    def getImageBuildVersionArn: ZIO[Any, AwsError, ImageBuildVersionArn] =
      AwsError.unwrapOptionField("imageBuildVersionArn", imageBuildVersionArn)
    def getMessage: ZIO[Any, AwsError, ImageBuildMessage] =
      AwsError.unwrapOptionField("message", message)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListWorkflowStepExecutionsResponse
  ) extends zio.aws.imagebuilder.model.ListWorkflowStepExecutionsResponse.ReadOnly {
    override val requestId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val steps: Optional[
      List[zio.aws.imagebuilder.model.WorkflowStepMetadata.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.steps())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.WorkflowStepMetadata.wrap(item)
        }.toList
      )
    override val workflowBuildVersionArn: Optional[WorkflowBuildVersionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workflowBuildVersionArn())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.WorkflowBuildVersionArn(value)
        )
    override val workflowExecutionId: Optional[WorkflowExecutionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workflowExecutionId())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.WorkflowExecutionId(value)
        )
    override val imageBuildVersionArn: Optional[ImageBuildVersionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageBuildVersionArn())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.ImageBuildVersionArn(value)
        )
    override val message: Optional[ImageBuildMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.ImageBuildMessage(value)
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListWorkflowStepExecutionsResponse
  ): zio.aws.imagebuilder.model.ListWorkflowStepExecutionsResponse.ReadOnly =
    new Wrapper(impl)
}
