package zio.aws.imagebuilder.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.imagebuilder.model.primitives.{
  PackageArchitecture,
  PackageEpoch,
  SourceLayerHash,
  NonEmptyString
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class VulnerablePackage(
    name: Optional[NonEmptyString] = Optional.Absent,
    version: Optional[NonEmptyString] = Optional.Absent,
    sourceLayerHash: Optional[SourceLayerHash] = Optional.Absent,
    epoch: Optional[PackageEpoch] = Optional.Absent,
    release: Optional[NonEmptyString] = Optional.Absent,
    arch: Optional[PackageArchitecture] = Optional.Absent,
    packageManager: Optional[NonEmptyString] = Optional.Absent,
    filePath: Optional[NonEmptyString] = Optional.Absent,
    fixedInVersion: Optional[NonEmptyString] = Optional.Absent,
    remediation: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.VulnerablePackage = {
    import VulnerablePackage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.VulnerablePackage
      .builder()
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        version.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(
        sourceLayerHash.map(value =>
          SourceLayerHash.unwrap(value): java.lang.String
        )
      )(_.sourceLayerHash)
      .optionallyWith(epoch.map(value => PackageEpoch.unwrap(value): Integer))(
        _.epoch
      )
      .optionallyWith(
        release.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.release)
      .optionallyWith(
        arch.map(value => PackageArchitecture.unwrap(value): java.lang.String)
      )(_.arch)
      .optionallyWith(
        packageManager.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.packageManager)
      .optionallyWith(
        filePath.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.filePath)
      .optionallyWith(
        fixedInVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.fixedInVersion)
      .optionallyWith(
        remediation.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.remediation)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.VulnerablePackage.ReadOnly =
    zio.aws.imagebuilder.model.VulnerablePackage.wrap(buildAwsValue())
}
object VulnerablePackage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.VulnerablePackage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.VulnerablePackage =
      zio.aws.imagebuilder.model.VulnerablePackage(
        name.map(value => value),
        version.map(value => value),
        sourceLayerHash.map(value => value),
        epoch.map(value => value),
        release.map(value => value),
        arch.map(value => value),
        packageManager.map(value => value),
        filePath.map(value => value),
        fixedInVersion.map(value => value),
        remediation.map(value => value)
      )
    def name: Optional[NonEmptyString]
    def version: Optional[NonEmptyString]
    def sourceLayerHash: Optional[SourceLayerHash]
    def epoch: Optional[PackageEpoch]
    def release: Optional[NonEmptyString]
    def arch: Optional[PackageArchitecture]
    def packageManager: Optional[NonEmptyString]
    def filePath: Optional[NonEmptyString]
    def fixedInVersion: Optional[NonEmptyString]
    def remediation: Optional[NonEmptyString]
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("version", version)
    def getSourceLayerHash: ZIO[Any, AwsError, SourceLayerHash] =
      AwsError.unwrapOptionField("sourceLayerHash", sourceLayerHash)
    def getEpoch: ZIO[Any, AwsError, PackageEpoch] =
      AwsError.unwrapOptionField("epoch", epoch)
    def getRelease: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("release", release)
    def getArch: ZIO[Any, AwsError, PackageArchitecture] =
      AwsError.unwrapOptionField("arch", arch)
    def getPackageManager: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("packageManager", packageManager)
    def getFilePath: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("filePath", filePath)
    def getFixedInVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("fixedInVersion", fixedInVersion)
    def getRemediation: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("remediation", remediation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.VulnerablePackage
  ) extends zio.aws.imagebuilder.model.VulnerablePackage.ReadOnly {
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val version: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val sourceLayerHash: Optional[SourceLayerHash] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceLayerHash())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.SourceLayerHash(value)
        )
    override val epoch: Optional[PackageEpoch] = zio.aws.core.internal
      .optionalFromNullable(impl.epoch())
      .map(value => zio.aws.imagebuilder.model.primitives.PackageEpoch(value))
    override val release: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.release())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val arch: Optional[PackageArchitecture] = zio.aws.core.internal
      .optionalFromNullable(impl.arch())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.PackageArchitecture(value)
      )
    override val packageManager: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.packageManager())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.NonEmptyString(value)
        )
    override val filePath: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.filePath())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val fixedInVersion: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fixedInVersion())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.NonEmptyString(value)
        )
    override val remediation: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.remediation())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.VulnerablePackage
  ): zio.aws.imagebuilder.model.VulnerablePackage.ReadOnly = new Wrapper(impl)
}
