package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VulnerabilityIdAggregation(
    vulnerabilityId: Optional[NonEmptyString] = Optional.Absent,
    severityCounts: Optional[zio.aws.imagebuilder.model.SeverityCounts] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.VulnerabilityIdAggregation = {
    import VulnerabilityIdAggregation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.VulnerabilityIdAggregation
      .builder()
      .optionallyWith(
        vulnerabilityId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.vulnerabilityId)
      .optionallyWith(severityCounts.map(value => value.buildAwsValue()))(
        _.severityCounts
      )
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.VulnerabilityIdAggregation.ReadOnly =
    zio.aws.imagebuilder.model.VulnerabilityIdAggregation.wrap(buildAwsValue())
}
object VulnerabilityIdAggregation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.VulnerabilityIdAggregation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.VulnerabilityIdAggregation =
      zio.aws.imagebuilder.model.VulnerabilityIdAggregation(
        vulnerabilityId.map(value => value),
        severityCounts.map(value => value.asEditable)
      )
    def vulnerabilityId: Optional[NonEmptyString]
    def severityCounts
        : Optional[zio.aws.imagebuilder.model.SeverityCounts.ReadOnly]
    def getVulnerabilityId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("vulnerabilityId", vulnerabilityId)
    def getSeverityCounts: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.SeverityCounts.ReadOnly
    ] = AwsError.unwrapOptionField("severityCounts", severityCounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.VulnerabilityIdAggregation
  ) extends zio.aws.imagebuilder.model.VulnerabilityIdAggregation.ReadOnly {
    override val vulnerabilityId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vulnerabilityId())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.NonEmptyString(value)
        )
    override val severityCounts
        : Optional[zio.aws.imagebuilder.model.SeverityCounts.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severityCounts())
        .map(value => zio.aws.imagebuilder.model.SeverityCounts.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.VulnerabilityIdAggregation
  ): zio.aws.imagebuilder.model.VulnerabilityIdAggregation.ReadOnly =
    new Wrapper(impl)
}
