package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListImageScanFindingAggregationsRequest(
    filter: Optional[zio.aws.imagebuilder.model.Filter] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingAggregationsRequest = {
    import ListImageScanFindingAggregationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingAggregationsRequest
      .builder()
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.ListImageScanFindingAggregationsRequest.ReadOnly =
    zio.aws.imagebuilder.model.ListImageScanFindingAggregationsRequest
      .wrap(buildAwsValue())
}
object ListImageScanFindingAggregationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingAggregationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.ListImageScanFindingAggregationsRequest =
      zio.aws.imagebuilder.model.ListImageScanFindingAggregationsRequest(
        filter.map(value => value.asEditable),
        nextToken.map(value => value)
      )
    def filter: Optional[zio.aws.imagebuilder.model.Filter.ReadOnly]
    def nextToken: Optional[PaginationToken]
    def getFilter
        : ZIO[Any, AwsError, zio.aws.imagebuilder.model.Filter.ReadOnly] =
      AwsError.unwrapOptionField("filter", filter)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingAggregationsRequest
  ) extends zio.aws.imagebuilder.model.ListImageScanFindingAggregationsRequest.ReadOnly {
    override val filter: Optional[zio.aws.imagebuilder.model.Filter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value => zio.aws.imagebuilder.model.Filter.wrap(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingAggregationsRequest
  ): zio.aws.imagebuilder.model.ListImageScanFindingAggregationsRequest.ReadOnly =
    new Wrapper(impl)
}
