package zio.aws.imagebuilder.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.imagebuilder.model.primitives.{
  ImageBuildVersionArn,
  PaginationToken,
  RestrictedInteger
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListWorkflowExecutionsRequest(
    maxResults: Optional[RestrictedInteger] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    imageBuildVersionArn: ImageBuildVersionArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ListWorkflowExecutionsRequest = {
    import ListWorkflowExecutionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ListWorkflowExecutionsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => RestrictedInteger.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .imageBuildVersionArn(
        ImageBuildVersionArn.unwrap(imageBuildVersionArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.ListWorkflowExecutionsRequest.ReadOnly =
    zio.aws.imagebuilder.model.ListWorkflowExecutionsRequest
      .wrap(buildAwsValue())
}
object ListWorkflowExecutionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ListWorkflowExecutionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ListWorkflowExecutionsRequest =
      zio.aws.imagebuilder.model.ListWorkflowExecutionsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        imageBuildVersionArn
      )
    def maxResults: Optional[RestrictedInteger]
    def nextToken: Optional[PaginationToken]
    def imageBuildVersionArn: ImageBuildVersionArn
    def getMaxResults: ZIO[Any, AwsError, RestrictedInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getImageBuildVersionArn: ZIO[Any, Nothing, ImageBuildVersionArn] =
      ZIO.succeed(imageBuildVersionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListWorkflowExecutionsRequest
  ) extends zio.aws.imagebuilder.model.ListWorkflowExecutionsRequest.ReadOnly {
    override val maxResults: Optional[RestrictedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.RestrictedInteger(value)
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.PaginationToken(value)
      )
    override val imageBuildVersionArn: ImageBuildVersionArn =
      zio.aws.imagebuilder.model.primitives
        .ImageBuildVersionArn(impl.imageBuildVersionArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListWorkflowExecutionsRequest
  ): zio.aws.imagebuilder.model.ListWorkflowExecutionsRequest.ReadOnly =
    new Wrapper(impl)
}
