package zio.aws.imagebuilder.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.imagebuilder.model.primitives.{NonEmptyString, RestrictedInteger}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListContainerRecipesRequest(
    owner: Optional[zio.aws.imagebuilder.model.Ownership] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.imagebuilder.model.Filter]] =
      Optional.Absent,
    maxResults: Optional[RestrictedInteger] = Optional.Absent,
    nextToken: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesRequest = {
    import ListContainerRecipesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesRequest
      .builder()
      .optionallyWith(owner.map(value => value.unwrap))(_.owner)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => RestrictedInteger.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.ListContainerRecipesRequest.ReadOnly =
    zio.aws.imagebuilder.model.ListContainerRecipesRequest.wrap(buildAwsValue())
}
object ListContainerRecipesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ListContainerRecipesRequest =
      zio.aws.imagebuilder.model.ListContainerRecipesRequest(
        owner.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def owner: Optional[zio.aws.imagebuilder.model.Ownership]
    def filters: Optional[List[zio.aws.imagebuilder.model.Filter.ReadOnly]]
    def maxResults: Optional[RestrictedInteger]
    def nextToken: Optional[NonEmptyString]
    def getOwner: ZIO[Any, AwsError, zio.aws.imagebuilder.model.Ownership] =
      AwsError.unwrapOptionField("owner", owner)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.imagebuilder.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, RestrictedInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesRequest
  ) extends zio.aws.imagebuilder.model.ListContainerRecipesRequest.ReadOnly {
    override val owner: Optional[zio.aws.imagebuilder.model.Ownership] =
      zio.aws.core.internal
        .optionalFromNullable(impl.owner())
        .map(value => zio.aws.imagebuilder.model.Ownership.wrap(value))
    override val filters
        : Optional[List[zio.aws.imagebuilder.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.imagebuilder.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Optional[RestrictedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.RestrictedInteger(value)
      )
    override val nextToken: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesRequest
  ): zio.aws.imagebuilder.model.ListContainerRecipesRequest.ReadOnly =
    new Wrapper(impl)
}
