package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{FilterValue, FilterName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ImageScanFindingsFilter(
    name: Optional[FilterName] = Optional.Absent,
    values: Optional[Iterable[FilterValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ImageScanFindingsFilter = {
    import ImageScanFindingsFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ImageScanFindingsFilter
      .builder()
      .optionallyWith(
        name.map(value => FilterName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            FilterValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.ImageScanFindingsFilter.ReadOnly =
    zio.aws.imagebuilder.model.ImageScanFindingsFilter.wrap(buildAwsValue())
}
object ImageScanFindingsFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ImageScanFindingsFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ImageScanFindingsFilter =
      zio.aws.imagebuilder.model.ImageScanFindingsFilter(
        name.map(value => value),
        values.map(value => value)
      )
    def name: Optional[FilterName]
    def values: Optional[List[FilterValue]]
    def getName: ZIO[Any, AwsError, FilterName] =
      AwsError.unwrapOptionField("name", name)
    def getValues: ZIO[Any, AwsError, List[FilterValue]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ImageScanFindingsFilter
  ) extends zio.aws.imagebuilder.model.ImageScanFindingsFilter.ReadOnly {
    override val name: Optional[FilterName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.imagebuilder.model.primitives.FilterName(value))
    override val values: Optional[List[FilterValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.values())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.primitives.FilterValue(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ImageScanFindingsFilter
  ): zio.aws.imagebuilder.model.ImageScanFindingsFilter.ReadOnly = new Wrapper(
    impl
  )
}
