package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.ImageBuildVersionArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ImageAggregation(
    imageBuildVersionArn: Optional[ImageBuildVersionArn] = Optional.Absent,
    severityCounts: Optional[zio.aws.imagebuilder.model.SeverityCounts] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ImageAggregation = {
    import ImageAggregation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ImageAggregation
      .builder()
      .optionallyWith(
        imageBuildVersionArn.map(value =>
          ImageBuildVersionArn.unwrap(value): java.lang.String
        )
      )(_.imageBuildVersionArn)
      .optionallyWith(severityCounts.map(value => value.buildAwsValue()))(
        _.severityCounts
      )
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.ImageAggregation.ReadOnly =
    zio.aws.imagebuilder.model.ImageAggregation.wrap(buildAwsValue())
}
object ImageAggregation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ImageAggregation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ImageAggregation =
      zio.aws.imagebuilder.model.ImageAggregation(
        imageBuildVersionArn.map(value => value),
        severityCounts.map(value => value.asEditable)
      )
    def imageBuildVersionArn: Optional[ImageBuildVersionArn]
    def severityCounts
        : Optional[zio.aws.imagebuilder.model.SeverityCounts.ReadOnly]
    def getImageBuildVersionArn: ZIO[Any, AwsError, ImageBuildVersionArn] =
      AwsError.unwrapOptionField("imageBuildVersionArn", imageBuildVersionArn)
    def getSeverityCounts: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.SeverityCounts.ReadOnly
    ] = AwsError.unwrapOptionField("severityCounts", severityCounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ImageAggregation
  ) extends zio.aws.imagebuilder.model.ImageAggregation.ReadOnly {
    override val imageBuildVersionArn: Optional[ImageBuildVersionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageBuildVersionArn())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.ImageBuildVersionArn(value)
        )
    override val severityCounts
        : Optional[zio.aws.imagebuilder.model.SeverityCounts.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severityCounts())
        .map(value => zio.aws.imagebuilder.model.SeverityCounts.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ImageAggregation
  ): zio.aws.imagebuilder.model.ImageAggregation.ReadOnly = new Wrapper(impl)
}
