package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RemediationRecommendation(
    text: Optional[NonEmptyString] = Optional.Absent,
    url: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.RemediationRecommendation = {
    import RemediationRecommendation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.RemediationRecommendation
      .builder()
      .optionallyWith(
        text.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.text)
      .optionallyWith(
        url.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.url)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.RemediationRecommendation.ReadOnly =
    zio.aws.imagebuilder.model.RemediationRecommendation.wrap(buildAwsValue())
}
object RemediationRecommendation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.RemediationRecommendation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.RemediationRecommendation =
      zio.aws.imagebuilder.model.RemediationRecommendation(
        text.map(value => value),
        url.map(value => value)
      )
    def text: Optional[NonEmptyString]
    def url: Optional[NonEmptyString]
    def getText: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("text", text)
    def getUrl: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("url", url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.RemediationRecommendation
  ) extends zio.aws.imagebuilder.model.RemediationRecommendation.ReadOnly {
    override val text: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.text())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val url: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.url())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.RemediationRecommendation
  ): zio.aws.imagebuilder.model.RemediationRecommendation.ReadOnly =
    new Wrapper(impl)
}
