package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.ImagePipelineArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ImagePipelineAggregation(
    imagePipelineArn: Optional[ImagePipelineArn] = Optional.Absent,
    severityCounts: Optional[zio.aws.imagebuilder.model.SeverityCounts] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ImagePipelineAggregation = {
    import ImagePipelineAggregation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ImagePipelineAggregation
      .builder()
      .optionallyWith(
        imagePipelineArn.map(value =>
          ImagePipelineArn.unwrap(value): java.lang.String
        )
      )(_.imagePipelineArn)
      .optionallyWith(severityCounts.map(value => value.buildAwsValue()))(
        _.severityCounts
      )
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.ImagePipelineAggregation.ReadOnly =
    zio.aws.imagebuilder.model.ImagePipelineAggregation.wrap(buildAwsValue())
}
object ImagePipelineAggregation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ImagePipelineAggregation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ImagePipelineAggregation =
      zio.aws.imagebuilder.model.ImagePipelineAggregation(
        imagePipelineArn.map(value => value),
        severityCounts.map(value => value.asEditable)
      )
    def imagePipelineArn: Optional[ImagePipelineArn]
    def severityCounts
        : Optional[zio.aws.imagebuilder.model.SeverityCounts.ReadOnly]
    def getImagePipelineArn: ZIO[Any, AwsError, ImagePipelineArn] =
      AwsError.unwrapOptionField("imagePipelineArn", imagePipelineArn)
    def getSeverityCounts: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.SeverityCounts.ReadOnly
    ] = AwsError.unwrapOptionField("severityCounts", severityCounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ImagePipelineAggregation
  ) extends zio.aws.imagebuilder.model.ImagePipelineAggregation.ReadOnly {
    override val imagePipelineArn: Optional[ImagePipelineArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imagePipelineArn())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.ImagePipelineArn(value)
        )
    override val severityCounts
        : Optional[zio.aws.imagebuilder.model.SeverityCounts.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severityCounts())
        .map(value => zio.aws.imagebuilder.model.SeverityCounts.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ImagePipelineAggregation
  ): zio.aws.imagebuilder.model.ImagePipelineAggregation.ReadOnly = new Wrapper(
    impl
  )
}
