package zio.aws.imagebuilder.model
import scala.jdk.CollectionConverters._
sealed trait ContainerType {
  def unwrap: software.amazon.awssdk.services.imagebuilder.model.ContainerType
}
object ContainerType {
  def wrap(
      value: software.amazon.awssdk.services.imagebuilder.model.ContainerType
  ): zio.aws.imagebuilder.model.ContainerType = value match {
    case software.amazon.awssdk.services.imagebuilder.model.ContainerType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.imagebuilder.model.ContainerType.DOCKER =>
      val r = DOCKER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.imagebuilder.model.ContainerType {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ContainerType =
      software.amazon.awssdk.services.imagebuilder.model.ContainerType.UNKNOWN_TO_SDK_VERSION
  }
  case object DOCKER extends zio.aws.imagebuilder.model.ContainerType {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ContainerType =
      software.amazon.awssdk.services.imagebuilder.model.ContainerType.DOCKER
  }
}
