package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  ComponentParameterDescription,
  ComponentParameterValue,
  ComponentParameterType,
  ComponentParameterName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ComponentParameterDetail(
    name: ComponentParameterName,
    `type`: ComponentParameterType,
    defaultValue: Optional[Iterable[ComponentParameterValue]] = Optional.Absent,
    description: Optional[ComponentParameterDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ComponentParameterDetail = {
    import ComponentParameterDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ComponentParameterDetail
      .builder()
      .name(ComponentParameterName.unwrap(name): java.lang.String)
      .`type`(ComponentParameterType.unwrap(`type`): java.lang.String)
      .optionallyWith(
        defaultValue.map(value =>
          value.map { item =>
            ComponentParameterValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.defaultValue)
      .optionallyWith(
        description.map(value =>
          ComponentParameterDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.ComponentParameterDetail.ReadOnly =
    zio.aws.imagebuilder.model.ComponentParameterDetail.wrap(buildAwsValue())
}
object ComponentParameterDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ComponentParameterDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ComponentParameterDetail =
      zio.aws.imagebuilder.model.ComponentParameterDetail(
        name,
        `type`,
        defaultValue.map(value => value),
        description.map(value => value)
      )
    def name: ComponentParameterName
    def `type`: ComponentParameterType
    def defaultValue: Optional[List[ComponentParameterValue]]
    def description: Optional[ComponentParameterDescription]
    def getName: ZIO[Any, Nothing, ComponentParameterName] = ZIO.succeed(name)
    def getType: ZIO[Any, Nothing, ComponentParameterType] = ZIO.succeed(`type`)
    def getDefaultValue: ZIO[Any, AwsError, List[ComponentParameterValue]] =
      AwsError.unwrapOptionField("defaultValue", defaultValue)
    def getDescription: ZIO[Any, AwsError, ComponentParameterDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ComponentParameterDetail
  ) extends zio.aws.imagebuilder.model.ComponentParameterDetail.ReadOnly {
    override val name: ComponentParameterName =
      zio.aws.imagebuilder.model.primitives.ComponentParameterName(impl.name())
    override val `type`: ComponentParameterType =
      zio.aws.imagebuilder.model.primitives
        .ComponentParameterType(impl.`type`())
    override val defaultValue: Optional[List[ComponentParameterValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultValue())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.imagebuilder.model.primitives.ComponentParameterValue(item)
          }.toList
        )
    override val description: Optional[ComponentParameterDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.imagebuilder.model.primitives
            .ComponentParameterDescription(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ComponentParameterDetail
  ): zio.aws.imagebuilder.model.ComponentParameterDetail.ReadOnly = new Wrapper(
    impl
  )
}
