package zio.aws.imagebuilder.model
import scala.jdk.CollectionConverters._
sealed trait ComponentFormat {
  def unwrap: software.amazon.awssdk.services.imagebuilder.model.ComponentFormat
}
object ComponentFormat {
  def wrap(
      value: software.amazon.awssdk.services.imagebuilder.model.ComponentFormat
  ): zio.aws.imagebuilder.model.ComponentFormat = value match {
    case software.amazon.awssdk.services.imagebuilder.model.ComponentFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.imagebuilder.model.ComponentFormat.SHELL =>
      val r = SHELL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.imagebuilder.model.ComponentFormat {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ComponentFormat =
      software.amazon.awssdk.services.imagebuilder.model.ComponentFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object SHELL extends zio.aws.imagebuilder.model.ComponentFormat {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ComponentFormat =
      software.amazon.awssdk.services.imagebuilder.model.ComponentFormat.SHELL
  }
}
