package zio.aws.imagebuilder.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.imagebuilder.model.primitives.{
  HttpPutResponseHopLimit,
  HttpTokens
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class InstanceMetadataOptions(
    httpTokens: Optional[HttpTokens] = Optional.Absent,
    httpPutResponseHopLimit: Optional[HttpPutResponseHopLimit] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.InstanceMetadataOptions = {
    import InstanceMetadataOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.InstanceMetadataOptions
      .builder()
      .optionallyWith(
        httpTokens.map(value => HttpTokens.unwrap(value): java.lang.String)
      )(_.httpTokens)
      .optionallyWith(
        httpPutResponseHopLimit.map(value =>
          HttpPutResponseHopLimit.unwrap(value): Integer
        )
      )(_.httpPutResponseHopLimit)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.InstanceMetadataOptions.ReadOnly =
    zio.aws.imagebuilder.model.InstanceMetadataOptions.wrap(buildAwsValue())
}
object InstanceMetadataOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.InstanceMetadataOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.InstanceMetadataOptions =
      zio.aws.imagebuilder.model.InstanceMetadataOptions(
        httpTokens.map(value => value),
        httpPutResponseHopLimit.map(value => value)
      )
    def httpTokens: Optional[HttpTokens]
    def httpPutResponseHopLimit: Optional[HttpPutResponseHopLimit]
    def getHttpTokens: ZIO[Any, AwsError, HttpTokens] =
      AwsError.unwrapOptionField("httpTokens", httpTokens)
    def getHttpPutResponseHopLimit
        : ZIO[Any, AwsError, HttpPutResponseHopLimit] = AwsError
      .unwrapOptionField("httpPutResponseHopLimit", httpPutResponseHopLimit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.InstanceMetadataOptions
  ) extends zio.aws.imagebuilder.model.InstanceMetadataOptions.ReadOnly {
    override val httpTokens: Optional[HttpTokens] = zio.aws.core.internal
      .optionalFromNullable(impl.httpTokens())
      .map(value => zio.aws.imagebuilder.model.primitives.HttpTokens(value))
    override val httpPutResponseHopLimit: Optional[HttpPutResponseHopLimit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.httpPutResponseHopLimit())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.HttpPutResponseHopLimit(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.InstanceMetadataOptions
  ): zio.aws.imagebuilder.model.InstanceMetadataOptions.ReadOnly = new Wrapper(
    impl
  )
}
