package zio.aws.imagebuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InspectorScoreDetails(
    adjustedCvss: Optional[zio.aws.imagebuilder.model.CvssScoreDetails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.InspectorScoreDetails = {
    import InspectorScoreDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.InspectorScoreDetails
      .builder()
      .optionallyWith(adjustedCvss.map(value => value.buildAwsValue()))(
        _.adjustedCvss
      )
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.InspectorScoreDetails.ReadOnly =
    zio.aws.imagebuilder.model.InspectorScoreDetails.wrap(buildAwsValue())
}
object InspectorScoreDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.InspectorScoreDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.InspectorScoreDetails =
      zio.aws.imagebuilder.model
        .InspectorScoreDetails(adjustedCvss.map(value => value.asEditable))
    def adjustedCvss
        : Optional[zio.aws.imagebuilder.model.CvssScoreDetails.ReadOnly]
    def getAdjustedCvss: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.CvssScoreDetails.ReadOnly
    ] = AwsError.unwrapOptionField("adjustedCvss", adjustedCvss)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.InspectorScoreDetails
  ) extends zio.aws.imagebuilder.model.InspectorScoreDetails.ReadOnly {
    override val adjustedCvss
        : Optional[zio.aws.imagebuilder.model.CvssScoreDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.adjustedCvss())
        .map(value => zio.aws.imagebuilder.model.CvssScoreDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.InspectorScoreDetails
  ): zio.aws.imagebuilder.model.InspectorScoreDetails.ReadOnly = new Wrapper(
    impl
  )
}
