package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{PaginationToken, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListImageScanFindingsResponse(
    requestId: Optional[NonEmptyString] = Optional.Absent,
    findings: Optional[Iterable[zio.aws.imagebuilder.model.ImageScanFinding]] =
      Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingsResponse = {
    import ListImageScanFindingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingsResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        findings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.findings)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.ListImageScanFindingsResponse.ReadOnly =
    zio.aws.imagebuilder.model.ListImageScanFindingsResponse
      .wrap(buildAwsValue())
}
object ListImageScanFindingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ListImageScanFindingsResponse =
      zio.aws.imagebuilder.model.ListImageScanFindingsResponse(
        requestId.map(value => value),
        findings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def requestId: Optional[NonEmptyString]
    def findings
        : Optional[List[zio.aws.imagebuilder.model.ImageScanFinding.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getFindings: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.ImageScanFinding.ReadOnly
    ]] = AwsError.unwrapOptionField("findings", findings)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingsResponse
  ) extends zio.aws.imagebuilder.model.ListImageScanFindingsResponse.ReadOnly {
    override val requestId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val findings
        : Optional[List[zio.aws.imagebuilder.model.ImageScanFinding.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.findings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.imagebuilder.model.ImageScanFinding.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingsResponse
  ): zio.aws.imagebuilder.model.ListImageScanFindingsResponse.ReadOnly =
    new Wrapper(impl)
}
