package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.ImageBuildVersionArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetImagePolicyRequest(imageArn: ImageBuildVersionArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.GetImagePolicyRequest = {
    import GetImagePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.GetImagePolicyRequest
      .builder()
      .imageArn(ImageBuildVersionArn.unwrap(imageArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.GetImagePolicyRequest.ReadOnly =
    zio.aws.imagebuilder.model.GetImagePolicyRequest.wrap(buildAwsValue())
}
object GetImagePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.GetImagePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.GetImagePolicyRequest =
      zio.aws.imagebuilder.model.GetImagePolicyRequest(imageArn)
    def imageArn: ImageBuildVersionArn
    def getImageArn: ZIO[Any, Nothing, ImageBuildVersionArn] =
      ZIO.succeed(imageArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.GetImagePolicyRequest
  ) extends zio.aws.imagebuilder.model.GetImagePolicyRequest.ReadOnly {
    override val imageArn: ImageBuildVersionArn =
      zio.aws.imagebuilder.model.primitives
        .ImageBuildVersionArn(impl.imageArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.GetImagePolicyRequest
  ): zio.aws.imagebuilder.model.GetImagePolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
