package zio.aws.imagebuilder.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.imagebuilder.model.primitives.{
  PaginationToken,
  RestrictedInteger,
  ImageBuildVersionArn
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListImagePackagesRequest(
    imageBuildVersionArn: ImageBuildVersionArn,
    maxResults: Optional[RestrictedInteger] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesRequest = {
    import ListImagePackagesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesRequest
      .builder()
      .imageBuildVersionArn(
        ImageBuildVersionArn.unwrap(imageBuildVersionArn): java.lang.String
      )
      .optionallyWith(
        maxResults.map(value => RestrictedInteger.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.ListImagePackagesRequest.ReadOnly =
    zio.aws.imagebuilder.model.ListImagePackagesRequest.wrap(buildAwsValue())
}
object ListImagePackagesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ListImagePackagesRequest =
      zio.aws.imagebuilder.model.ListImagePackagesRequest(
        imageBuildVersionArn,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def imageBuildVersionArn: ImageBuildVersionArn
    def maxResults: Optional[RestrictedInteger]
    def nextToken: Optional[PaginationToken]
    def getImageBuildVersionArn: ZIO[Any, Nothing, ImageBuildVersionArn] =
      ZIO.succeed(imageBuildVersionArn)
    def getMaxResults: ZIO[Any, AwsError, RestrictedInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesRequest
  ) extends zio.aws.imagebuilder.model.ListImagePackagesRequest.ReadOnly {
    override val imageBuildVersionArn: ImageBuildVersionArn =
      zio.aws.imagebuilder.model.primitives
        .ImageBuildVersionArn(impl.imageBuildVersionArn())
    override val maxResults: Optional[RestrictedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.RestrictedInteger(value)
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesRequest
  ): zio.aws.imagebuilder.model.ListImagePackagesRequest.ReadOnly = new Wrapper(
    impl
  )
}
