package zio.aws.imagebuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OutputResources(
    amis: Optional[Iterable[zio.aws.imagebuilder.model.Ami]] = Optional.Absent,
    containers: Optional[Iterable[zio.aws.imagebuilder.model.Container]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.OutputResources = {
    import OutputResources.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.OutputResources
      .builder()
      .optionallyWith(
        amis.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.amis)
      .optionallyWith(
        containers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.containers)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.OutputResources.ReadOnly =
    zio.aws.imagebuilder.model.OutputResources.wrap(buildAwsValue())
}
object OutputResources {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.OutputResources
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.OutputResources =
      zio.aws.imagebuilder.model.OutputResources(
        amis.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        containers.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def amis: Optional[List[zio.aws.imagebuilder.model.Ami.ReadOnly]]
    def containers
        : Optional[List[zio.aws.imagebuilder.model.Container.ReadOnly]]
    def getAmis
        : ZIO[Any, AwsError, List[zio.aws.imagebuilder.model.Ami.ReadOnly]] =
      AwsError.unwrapOptionField("amis", amis)
    def getContainers: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.Container.ReadOnly
    ]] = AwsError.unwrapOptionField("containers", containers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.OutputResources
  ) extends zio.aws.imagebuilder.model.OutputResources.ReadOnly {
    override val amis: Optional[List[zio.aws.imagebuilder.model.Ami.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.amis())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.imagebuilder.model.Ami.wrap(item)
          }.toList
        )
    override val containers
        : Optional[List[zio.aws.imagebuilder.model.Container.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.containers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.imagebuilder.model.Container.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.OutputResources
  ): zio.aws.imagebuilder.model.OutputResources.ReadOnly = new Wrapper(impl)
}
