package zio.aws.imagebuilder.model
import scala.jdk.CollectionConverters._
sealed trait WorkflowStepExecutionStatus {
  def unwrap: software.amazon.awssdk.services.imagebuilder.model.WorkflowStepExecutionStatus
}
object WorkflowStepExecutionStatus {
  def wrap(
      value: software.amazon.awssdk.services.imagebuilder.model.WorkflowStepExecutionStatus
  ): zio.aws.imagebuilder.model.WorkflowStepExecutionStatus = value match {
    case software.amazon.awssdk.services.imagebuilder.model.WorkflowStepExecutionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.imagebuilder.model.WorkflowStepExecutionStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.imagebuilder.model.WorkflowStepExecutionStatus.SKIPPED =>
      val r = SKIPPED
      r
    case software.amazon.awssdk.services.imagebuilder.model.WorkflowStepExecutionStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.imagebuilder.model.WorkflowStepExecutionStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.imagebuilder.model.WorkflowStepExecutionStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.imagebuilder.model.WorkflowStepExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.WorkflowStepExecutionStatus =
      software.amazon.awssdk.services.imagebuilder.model.WorkflowStepExecutionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING
      extends zio.aws.imagebuilder.model.WorkflowStepExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.WorkflowStepExecutionStatus =
      software.amazon.awssdk.services.imagebuilder.model.WorkflowStepExecutionStatus.PENDING
  }
  case object SKIPPED
      extends zio.aws.imagebuilder.model.WorkflowStepExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.WorkflowStepExecutionStatus =
      software.amazon.awssdk.services.imagebuilder.model.WorkflowStepExecutionStatus.SKIPPED
  }
  case object RUNNING
      extends zio.aws.imagebuilder.model.WorkflowStepExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.WorkflowStepExecutionStatus =
      software.amazon.awssdk.services.imagebuilder.model.WorkflowStepExecutionStatus.RUNNING
  }
  case object COMPLETED
      extends zio.aws.imagebuilder.model.WorkflowStepExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.WorkflowStepExecutionStatus =
      software.amazon.awssdk.services.imagebuilder.model.WorkflowStepExecutionStatus.COMPLETED
  }
  case object FAILED
      extends zio.aws.imagebuilder.model.WorkflowStepExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.WorkflowStepExecutionStatus =
      software.amazon.awssdk.services.imagebuilder.model.WorkflowStepExecutionStatus.FAILED
  }
}
