package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{Timezone, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Schedule(
    scheduleExpression: Optional[NonEmptyString] = Optional.Absent,
    timezone: Optional[Timezone] = Optional.Absent,
    pipelineExecutionStartCondition: Optional[
      zio.aws.imagebuilder.model.PipelineExecutionStartCondition
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.Schedule = {
    import Schedule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.Schedule
      .builder()
      .optionallyWith(
        scheduleExpression.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.scheduleExpression)
      .optionallyWith(
        timezone.map(value => Timezone.unwrap(value): java.lang.String)
      )(_.timezone)
      .optionallyWith(
        pipelineExecutionStartCondition.map(value => value.unwrap)
      )(_.pipelineExecutionStartCondition)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.Schedule.ReadOnly =
    zio.aws.imagebuilder.model.Schedule.wrap(buildAwsValue())
}
object Schedule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.Schedule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.Schedule =
      zio.aws.imagebuilder.model.Schedule(
        scheduleExpression.map(value => value),
        timezone.map(value => value),
        pipelineExecutionStartCondition.map(value => value)
      )
    def scheduleExpression: Optional[NonEmptyString]
    def timezone: Optional[Timezone]
    def pipelineExecutionStartCondition
        : Optional[zio.aws.imagebuilder.model.PipelineExecutionStartCondition]
    def getScheduleExpression: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("scheduleExpression", scheduleExpression)
    def getTimezone: ZIO[Any, AwsError, Timezone] =
      AwsError.unwrapOptionField("timezone", timezone)
    def getPipelineExecutionStartCondition: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.PipelineExecutionStartCondition
    ] = AwsError.unwrapOptionField(
      "pipelineExecutionStartCondition",
      pipelineExecutionStartCondition
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.Schedule
  ) extends zio.aws.imagebuilder.model.Schedule.ReadOnly {
    override val scheduleExpression: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduleExpression())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.NonEmptyString(value)
        )
    override val timezone: Optional[Timezone] = zio.aws.core.internal
      .optionalFromNullable(impl.timezone())
      .map(value => zio.aws.imagebuilder.model.primitives.Timezone(value))
    override val pipelineExecutionStartCondition
        : Optional[zio.aws.imagebuilder.model.PipelineExecutionStartCondition] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineExecutionStartCondition())
        .map(value =>
          zio.aws.imagebuilder.model.PipelineExecutionStartCondition.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.Schedule
  ): zio.aws.imagebuilder.model.Schedule.ReadOnly = new Wrapper(impl)
}
