package zio.aws.imagebuilder.model
import scala.jdk.CollectionConverters._
sealed trait ImageScanStatus {
  def unwrap: software.amazon.awssdk.services.imagebuilder.model.ImageScanStatus
}
object ImageScanStatus {
  def wrap(
      value: software.amazon.awssdk.services.imagebuilder.model.ImageScanStatus
  ): zio.aws.imagebuilder.model.ImageScanStatus = value match {
    case software.amazon.awssdk.services.imagebuilder.model.ImageScanStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.imagebuilder.model.ImageScanStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.imagebuilder.model.ImageScanStatus.SCANNING =>
      val r = SCANNING
      r
    case software.amazon.awssdk.services.imagebuilder.model.ImageScanStatus.COLLECTING =>
      val r = COLLECTING
      r
    case software.amazon.awssdk.services.imagebuilder.model.ImageScanStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.imagebuilder.model.ImageScanStatus.ABANDONED =>
      val r = ABANDONED
      r
    case software.amazon.awssdk.services.imagebuilder.model.ImageScanStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.imagebuilder.model.ImageScanStatus.TIMED_OUT =>
      val r = TIMED_OUT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.imagebuilder.model.ImageScanStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ImageScanStatus =
      software.amazon.awssdk.services.imagebuilder.model.ImageScanStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.imagebuilder.model.ImageScanStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ImageScanStatus =
      software.amazon.awssdk.services.imagebuilder.model.ImageScanStatus.PENDING
  }
  case object SCANNING extends zio.aws.imagebuilder.model.ImageScanStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ImageScanStatus =
      software.amazon.awssdk.services.imagebuilder.model.ImageScanStatus.SCANNING
  }
  case object COLLECTING extends zio.aws.imagebuilder.model.ImageScanStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ImageScanStatus =
      software.amazon.awssdk.services.imagebuilder.model.ImageScanStatus.COLLECTING
  }
  case object COMPLETED extends zio.aws.imagebuilder.model.ImageScanStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ImageScanStatus =
      software.amazon.awssdk.services.imagebuilder.model.ImageScanStatus.COMPLETED
  }
  case object ABANDONED extends zio.aws.imagebuilder.model.ImageScanStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ImageScanStatus =
      software.amazon.awssdk.services.imagebuilder.model.ImageScanStatus.ABANDONED
  }
  case object FAILED extends zio.aws.imagebuilder.model.ImageScanStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ImageScanStatus =
      software.amazon.awssdk.services.imagebuilder.model.ImageScanStatus.FAILED
  }
  case object TIMED_OUT extends zio.aws.imagebuilder.model.ImageScanStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ImageScanStatus =
      software.amazon.awssdk.services.imagebuilder.model.ImageScanStatus.TIMED_OUT
  }
}
