package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.ComponentVersionArnOrBuildVersionArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ComponentConfiguration(
    componentArn: ComponentVersionArnOrBuildVersionArn,
    parameters: Optional[
      Iterable[zio.aws.imagebuilder.model.ComponentParameter]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ComponentConfiguration = {
    import ComponentConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ComponentConfiguration
      .builder()
      .componentArn(
        ComponentVersionArnOrBuildVersionArn.unwrap(
          componentArn
        ): java.lang.String
      )
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.ComponentConfiguration.ReadOnly =
    zio.aws.imagebuilder.model.ComponentConfiguration.wrap(buildAwsValue())
}
object ComponentConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ComponentConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ComponentConfiguration =
      zio.aws.imagebuilder.model.ComponentConfiguration(
        componentArn,
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def componentArn: ComponentVersionArnOrBuildVersionArn
    def parameters
        : Optional[List[zio.aws.imagebuilder.model.ComponentParameter.ReadOnly]]
    def getComponentArn
        : ZIO[Any, Nothing, ComponentVersionArnOrBuildVersionArn] =
      ZIO.succeed(componentArn)
    def getParameters: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.ComponentParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ComponentConfiguration
  ) extends zio.aws.imagebuilder.model.ComponentConfiguration.ReadOnly {
    override val componentArn: ComponentVersionArnOrBuildVersionArn =
      zio.aws.imagebuilder.model.primitives
        .ComponentVersionArnOrBuildVersionArn(impl.componentArn())
    override val parameters: Optional[
      List[zio.aws.imagebuilder.model.ComponentParameter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.parameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.ComponentParameter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ComponentConfiguration
  ): zio.aws.imagebuilder.model.ComponentConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
