package zio.aws.imagebuilder
import zio.aws.imagebuilder.model.UpdateImagePipelineResponse.ReadOnly
import zio.aws.imagebuilder.model.{
  ListComponentBuildVersionsRequest,
  PutComponentPolicyRequest,
  CreateInfrastructureConfigurationRequest,
  GetInfrastructureConfigurationRequest,
  CreateDistributionConfigurationRequest,
  ImportVmImageRequest,
  GetDistributionConfigurationRequest,
  CreateContainerRecipeRequest,
  DeleteComponentRequest,
  PutImagePolicyRequest,
  DeleteImagePipelineRequest,
  ListTagsForResourceRequest,
  GetImageRecipePolicyRequest,
  DeleteImageRequest,
  CreateComponentRequest,
  PutContainerRecipePolicyRequest,
  ListDistributionConfigurationsRequest,
  DeleteDistributionConfigurationRequest,
  ImportComponentRequest,
  DeleteContainerRecipeRequest,
  DeleteImageRecipeRequest,
  GetImageRecipeRequest,
  ListImageBuildVersionsRequest,
  GetContainerRecipePolicyRequest,
  ListContainerRecipesRequest,
  GetContainerRecipeRequest,
  CancelImageCreationRequest,
  UpdateImagePipelineRequest,
  UntagResourceRequest,
  PutImageRecipePolicyRequest,
  CreateImageRecipeRequest,
  GetImagePolicyRequest,
  StartImagePipelineExecutionRequest,
  ListComponentsRequest,
  CreateImageRequest,
  ListImagePipelinesRequest,
  GetComponentPolicyRequest,
  ListImagePackagesRequest,
  GetComponentRequest,
  GetImageRequest,
  UpdateInfrastructureConfigurationRequest,
  ListImageRecipesRequest,
  ListInfrastructureConfigurationsRequest,
  DeleteInfrastructureConfigurationRequest,
  UpdateDistributionConfigurationRequest,
  GetImagePipelineRequest,
  TagResourceRequest,
  ListImagesRequest,
  CreateImagePipelineRequest,
  ListImagePipelineImagesRequest
}
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.imagebuilder.model.{
  UpdateImagePipelineResponse,
  CreateComponentResponse,
  ContainerRecipeSummary,
  ListImagePackagesResponse,
  GetImageRecipeResponse,
  ImageSummary,
  GetDistributionConfigurationResponse,
  ImagePackage,
  PutComponentPolicyResponse,
  ComponentVersion,
  GetContainerRecipeResponse,
  ListContainerRecipesResponse,
  DeleteDistributionConfigurationResponse,
  DeleteInfrastructureConfigurationResponse,
  DeleteContainerRecipeResponse,
  DeleteImagePipelineResponse,
  ImportComponentResponse,
  ImageRecipeSummary,
  ImageVersion,
  CreateContainerRecipeResponse,
  DeleteComponentResponse,
  GetComponentResponse,
  ComponentSummary,
  DeleteImageRecipeResponse,
  GetContainerRecipePolicyResponse,
  CreateImagePipelineResponse,
  GetImagePipelineResponse,
  DistributionConfigurationSummary,
  ListTagsForResourceResponse,
  CreateImageRecipeResponse,
  ListImagePipelinesResponse,
  UntagResourceResponse,
  UpdateDistributionConfigurationResponse,
  ImportVmImageResponse,
  ListImageBuildVersionsResponse,
  PutContainerRecipePolicyResponse,
  GetInfrastructureConfigurationResponse,
  StartImagePipelineExecutionResponse,
  GetImageResponse,
  ListImagePipelineImagesResponse,
  ImagePipeline,
  ListImagesResponse,
  CreateDistributionConfigurationResponse,
  ListImageRecipesResponse,
  PutImageRecipePolicyResponse,
  PutImagePolicyResponse,
  GetComponentPolicyResponse,
  DeleteImageResponse,
  ListInfrastructureConfigurationsResponse,
  UpdateInfrastructureConfigurationResponse,
  ListComponentsResponse,
  GetImageRecipePolicyResponse,
  CreateImageResponse,
  TagResourceResponse,
  ListComponentBuildVersionsResponse,
  InfrastructureConfigurationSummary,
  CreateInfrastructureConfigurationResponse,
  CancelImageCreationResponse,
  ListDistributionConfigurationsResponse,
  GetImagePolicyResponse
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import software.amazon.awssdk.services.imagebuilder.paginators.{
  ListImagePackagesPublisher,
  ListImagePipelineImagesPublisher,
  ListImagePipelinesPublisher,
  ListImageRecipesPublisher,
  ListComponentBuildVersionsPublisher,
  ListComponentsPublisher,
  ListInfrastructureConfigurationsPublisher,
  ListContainerRecipesPublisher,
  ListDistributionConfigurationsPublisher,
  ListImagesPublisher,
  ListImageBuildVersionsPublisher
}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.imagebuilder.{
  ImagebuilderAsyncClientBuilder,
  ImagebuilderAsyncClient
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait Imagebuilder extends AspectSupport[Imagebuilder] {
  val api: ImagebuilderAsyncClient
  def listImages(
      request: ListImagesRequest
  ): ZStream[Any, AwsError, zio.aws.imagebuilder.model.ImageVersion.ReadOnly]
  def listImagesPaginated(
      request: ListImagesRequest
  ): IO[AwsError, zio.aws.imagebuilder.model.ListImagesResponse.ReadOnly]
  def listImageRecipes(request: ListImageRecipesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.imagebuilder.model.ImageRecipeSummary.ReadOnly
  ]
  def listImageRecipesPaginated(
      request: ListImageRecipesRequest
  ): IO[AwsError, zio.aws.imagebuilder.model.ListImageRecipesResponse.ReadOnly]
  def putComponentPolicy(request: PutComponentPolicyRequest): IO[
    AwsError,
    zio.aws.imagebuilder.model.PutComponentPolicyResponse.ReadOnly
  ]
  def getImageRecipe(
      request: GetImageRecipeRequest
  ): IO[AwsError, zio.aws.imagebuilder.model.GetImageRecipeResponse.ReadOnly]
  def listImagePackages(
      request: ListImagePackagesRequest
  ): ZStream[Any, AwsError, zio.aws.imagebuilder.model.ImagePackage.ReadOnly]
  def listImagePackagesPaginated(
      request: ListImagePackagesRequest
  ): IO[AwsError, zio.aws.imagebuilder.model.ListImagePackagesResponse.ReadOnly]
  def getComponentPolicy(request: GetComponentPolicyRequest): IO[
    AwsError,
    zio.aws.imagebuilder.model.GetComponentPolicyResponse.ReadOnly
  ]
  def getContainerRecipe(request: GetContainerRecipeRequest): IO[
    AwsError,
    zio.aws.imagebuilder.model.GetContainerRecipeResponse.ReadOnly
  ]
  def startImagePipelineExecution(
      request: StartImagePipelineExecutionRequest
  ): IO[
    AwsError,
    zio.aws.imagebuilder.model.StartImagePipelineExecutionResponse.ReadOnly
  ]
  def updateDistributionConfiguration(
      request: UpdateDistributionConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.imagebuilder.model.UpdateDistributionConfigurationResponse.ReadOnly
  ]
  def deleteImage(
      request: DeleteImageRequest
  ): IO[AwsError, zio.aws.imagebuilder.model.DeleteImageResponse.ReadOnly]
  def createImageRecipe(
      request: CreateImageRecipeRequest
  ): IO[AwsError, zio.aws.imagebuilder.model.CreateImageRecipeResponse.ReadOnly]
  def listComponentBuildVersions(
      request: ListComponentBuildVersionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.imagebuilder.model.ComponentSummary.ReadOnly
  ]
  def listComponentBuildVersionsPaginated(
      request: ListComponentBuildVersionsRequest
  ): IO[
    AwsError,
    zio.aws.imagebuilder.model.ListComponentBuildVersionsResponse.ReadOnly
  ]
  def putImagePolicy(
      request: PutImagePolicyRequest
  ): IO[AwsError, zio.aws.imagebuilder.model.PutImagePolicyResponse.ReadOnly]
  def getDistributionConfiguration(
      request: GetDistributionConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.imagebuilder.model.GetDistributionConfigurationResponse.ReadOnly
  ]
  def deleteImageRecipe(
      request: DeleteImageRecipeRequest
  ): IO[AwsError, zio.aws.imagebuilder.model.DeleteImageRecipeResponse.ReadOnly]
  def createContainerRecipe(request: CreateContainerRecipeRequest): IO[
    AwsError,
    zio.aws.imagebuilder.model.CreateContainerRecipeResponse.ReadOnly
  ]
  def deleteDistributionConfiguration(
      request: DeleteDistributionConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.imagebuilder.model.DeleteDistributionConfigurationResponse.ReadOnly
  ]
  def putContainerRecipePolicy(request: PutContainerRecipePolicyRequest): IO[
    AwsError,
    zio.aws.imagebuilder.model.PutContainerRecipePolicyResponse.ReadOnly
  ]
  def createInfrastructureConfiguration(
      request: CreateInfrastructureConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.imagebuilder.model.CreateInfrastructureConfigurationResponse.ReadOnly
  ]
  def listComponents(request: ListComponentsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.imagebuilder.model.ComponentVersion.ReadOnly
  ]
  def listComponentsPaginated(
      request: ListComponentsRequest
  ): IO[AwsError, zio.aws.imagebuilder.model.ListComponentsResponse.ReadOnly]
  def createImage(
      request: CreateImageRequest
  ): IO[AwsError, zio.aws.imagebuilder.model.CreateImageResponse.ReadOnly]
  def deleteInfrastructureConfiguration(
      request: DeleteInfrastructureConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.imagebuilder.model.DeleteInfrastructureConfigurationResponse.ReadOnly
  ]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.imagebuilder.model.UntagResourceResponse.ReadOnly]
  def deleteComponent(
      request: DeleteComponentRequest
  ): IO[AwsError, zio.aws.imagebuilder.model.DeleteComponentResponse.ReadOnly]
  def listImagePipelines(
      request: ListImagePipelinesRequest
  ): ZStream[Any, AwsError, zio.aws.imagebuilder.model.ImagePipeline.ReadOnly]
  def listImagePipelinesPaginated(request: ListImagePipelinesRequest): IO[
    AwsError,
    zio.aws.imagebuilder.model.ListImagePipelinesResponse.ReadOnly
  ]
  def listDistributionConfigurations(
      request: ListDistributionConfigurationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.imagebuilder.model.DistributionConfigurationSummary.ReadOnly
  ]
  def listDistributionConfigurationsPaginated(
      request: ListDistributionConfigurationsRequest
  ): IO[
    AwsError,
    zio.aws.imagebuilder.model.ListDistributionConfigurationsResponse.ReadOnly
  ]
  def getContainerRecipePolicy(request: GetContainerRecipePolicyRequest): IO[
    AwsError,
    zio.aws.imagebuilder.model.GetContainerRecipePolicyResponse.ReadOnly
  ]
  def listImagePipelineImages(
      request: ListImagePipelineImagesRequest
  ): ZStream[Any, AwsError, zio.aws.imagebuilder.model.ImageSummary.ReadOnly]
  def listImagePipelineImagesPaginated(
      request: ListImagePipelineImagesRequest
  ): IO[
    AwsError,
    zio.aws.imagebuilder.model.ListImagePipelineImagesResponse.ReadOnly
  ]
  def createDistributionConfiguration(
      request: CreateDistributionConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.imagebuilder.model.CreateDistributionConfigurationResponse.ReadOnly
  ]
  def importComponent(
      request: ImportComponentRequest
  ): IO[AwsError, zio.aws.imagebuilder.model.ImportComponentResponse.ReadOnly]
  def createComponent(
      request: CreateComponentRequest
  ): IO[AwsError, zio.aws.imagebuilder.model.CreateComponentResponse.ReadOnly]
  def getImagePipeline(
      request: GetImagePipelineRequest
  ): IO[AwsError, zio.aws.imagebuilder.model.GetImagePipelineResponse.ReadOnly]
  def listTagsForResource(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.imagebuilder.model.ListTagsForResourceResponse.ReadOnly
  ]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.imagebuilder.model.TagResourceResponse.ReadOnly]
  def createImagePipeline(request: CreateImagePipelineRequest): IO[
    AwsError,
    zio.aws.imagebuilder.model.CreateImagePipelineResponse.ReadOnly
  ]
  def listInfrastructureConfigurations(
      request: ListInfrastructureConfigurationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.imagebuilder.model.InfrastructureConfigurationSummary.ReadOnly
  ]
  def listInfrastructureConfigurationsPaginated(
      request: ListInfrastructureConfigurationsRequest
  ): IO[
    AwsError,
    zio.aws.imagebuilder.model.ListInfrastructureConfigurationsResponse.ReadOnly
  ]
  def getInfrastructureConfiguration(
      request: GetInfrastructureConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.imagebuilder.model.GetInfrastructureConfigurationResponse.ReadOnly
  ]
  def deleteContainerRecipe(request: DeleteContainerRecipeRequest): IO[
    AwsError,
    zio.aws.imagebuilder.model.DeleteContainerRecipeResponse.ReadOnly
  ]
  def getImage(
      request: GetImageRequest
  ): IO[AwsError, zio.aws.imagebuilder.model.GetImageResponse.ReadOnly]
  def listContainerRecipes(request: ListContainerRecipesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.imagebuilder.model.ContainerRecipeSummary.ReadOnly
  ]
  def listContainerRecipesPaginated(request: ListContainerRecipesRequest): IO[
    AwsError,
    zio.aws.imagebuilder.model.ListContainerRecipesResponse.ReadOnly
  ]
  def deleteImagePipeline(request: DeleteImagePipelineRequest): IO[
    AwsError,
    zio.aws.imagebuilder.model.DeleteImagePipelineResponse.ReadOnly
  ]
  def putImageRecipePolicy(request: PutImageRecipePolicyRequest): IO[
    AwsError,
    zio.aws.imagebuilder.model.PutImageRecipePolicyResponse.ReadOnly
  ]
  def updateImagePipeline(
      request: UpdateImagePipelineRequest
  ): IO[AwsError, ReadOnly]
  def getImageRecipePolicy(request: GetImageRecipePolicyRequest): IO[
    AwsError,
    zio.aws.imagebuilder.model.GetImageRecipePolicyResponse.ReadOnly
  ]
  def listImageBuildVersions(
      request: ListImageBuildVersionsRequest
  ): ZStream[Any, AwsError, zio.aws.imagebuilder.model.ImageSummary.ReadOnly]
  def listImageBuildVersionsPaginated(
      request: ListImageBuildVersionsRequest
  ): IO[
    AwsError,
    zio.aws.imagebuilder.model.ListImageBuildVersionsResponse.ReadOnly
  ]
  def updateInfrastructureConfiguration(
      request: UpdateInfrastructureConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.imagebuilder.model.UpdateInfrastructureConfigurationResponse.ReadOnly
  ]
  def getComponent(
      request: GetComponentRequest
  ): IO[AwsError, zio.aws.imagebuilder.model.GetComponentResponse.ReadOnly]
  def importVmImage(
      request: ImportVmImageRequest
  ): IO[AwsError, zio.aws.imagebuilder.model.ImportVmImageResponse.ReadOnly]
  def cancelImageCreation(request: CancelImageCreationRequest): IO[
    AwsError,
    zio.aws.imagebuilder.model.CancelImageCreationResponse.ReadOnly
  ]
  def getImagePolicy(
      request: GetImagePolicyRequest
  ): IO[AwsError, zio.aws.imagebuilder.model.GetImagePolicyResponse.ReadOnly]
}
object Imagebuilder {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Imagebuilder] = customized(
    identity
  )
  def customized(
      customization: ImagebuilderAsyncClientBuilder => ImagebuilderAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Imagebuilder] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: ImagebuilderAsyncClientBuilder => ImagebuilderAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Imagebuilder] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = ImagebuilderAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[ImagebuilderAsyncClient, ImagebuilderAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      ImagebuilderAsyncClient,
      ImagebuilderAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new ImagebuilderImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class ImagebuilderImpl[R](
      override val api: ImagebuilderAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Imagebuilder
      with AwsServiceBase[R] {
    override val serviceName: String = "Imagebuilder"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): ImagebuilderImpl[R1] = new ImagebuilderImpl(api, newAspect, r)
    def listImages(request: ListImagesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.ImageVersion.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.imagebuilder.model.ListImagesRequest,
      ImageVersion,
      ListImagesPublisher
    ]("listImages", api.listImagesPaginator, _.imageVersionList())(
      request.buildAwsValue()
    ).map(item => zio.aws.imagebuilder.model.ImageVersion.wrap(item))
      .provideEnvironment(r)
    def listImagesPaginated(
        request: ListImagesRequest
    ): IO[AwsError, zio.aws.imagebuilder.model.ListImagesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.imagebuilder.model.ListImagesRequest,
        ListImagesResponse
      ]("listImages", api.listImages)(request.buildAwsValue())
        .map(zio.aws.imagebuilder.model.ListImagesResponse.wrap)
        .provideEnvironment(r)
    def listImageRecipes(request: ListImageRecipesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.ImageRecipeSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesRequest,
      ImageRecipeSummary,
      ListImageRecipesPublisher
    ](
      "listImageRecipes",
      api.listImageRecipesPaginator,
      _.imageRecipeSummaryList()
    )(request.buildAwsValue())
      .map(item => zio.aws.imagebuilder.model.ImageRecipeSummary.wrap(item))
      .provideEnvironment(r)
    def listImageRecipesPaginated(request: ListImageRecipesRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.ListImageRecipesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesRequest,
      ListImageRecipesResponse
    ]("listImageRecipes", api.listImageRecipes)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.ListImageRecipesResponse.wrap)
      .provideEnvironment(r)
    def putComponentPolicy(request: PutComponentPolicyRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.PutComponentPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.PutComponentPolicyRequest,
      PutComponentPolicyResponse
    ]("putComponentPolicy", api.putComponentPolicy)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.PutComponentPolicyResponse.wrap)
      .provideEnvironment(r)
    def getImageRecipe(request: GetImageRecipeRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.GetImageRecipeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.GetImageRecipeRequest,
      GetImageRecipeResponse
    ]("getImageRecipe", api.getImageRecipe)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.GetImageRecipeResponse.wrap)
      .provideEnvironment(r)
    def listImagePackages(request: ListImagePackagesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.ImagePackage.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesRequest,
      ImagePackage,
      ListImagePackagesPublisher
    ](
      "listImagePackages",
      api.listImagePackagesPaginator,
      _.imagePackageList()
    )(request.buildAwsValue())
      .map(item => zio.aws.imagebuilder.model.ImagePackage.wrap(item))
      .provideEnvironment(r)
    def listImagePackagesPaginated(request: ListImagePackagesRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.ListImagePackagesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.ListImagePackagesRequest,
      ListImagePackagesResponse
    ]("listImagePackages", api.listImagePackages)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.ListImagePackagesResponse.wrap)
      .provideEnvironment(r)
    def getComponentPolicy(request: GetComponentPolicyRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.GetComponentPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.GetComponentPolicyRequest,
      GetComponentPolicyResponse
    ]("getComponentPolicy", api.getComponentPolicy)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.GetComponentPolicyResponse.wrap)
      .provideEnvironment(r)
    def getContainerRecipe(request: GetContainerRecipeRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.GetContainerRecipeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.GetContainerRecipeRequest,
      GetContainerRecipeResponse
    ]("getContainerRecipe", api.getContainerRecipe)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.GetContainerRecipeResponse.wrap)
      .provideEnvironment(r)
    def startImagePipelineExecution(
        request: StartImagePipelineExecutionRequest
    ): IO[
      AwsError,
      zio.aws.imagebuilder.model.StartImagePipelineExecutionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.StartImagePipelineExecutionRequest,
      StartImagePipelineExecutionResponse
    ]("startImagePipelineExecution", api.startImagePipelineExecution)(
      request.buildAwsValue()
    ).map(zio.aws.imagebuilder.model.StartImagePipelineExecutionResponse.wrap)
      .provideEnvironment(r)
    def updateDistributionConfiguration(
        request: UpdateDistributionConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.imagebuilder.model.UpdateDistributionConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.UpdateDistributionConfigurationRequest,
      UpdateDistributionConfigurationResponse
    ]("updateDistributionConfiguration", api.updateDistributionConfiguration)(
      request.buildAwsValue()
    ).map(
      zio.aws.imagebuilder.model.UpdateDistributionConfigurationResponse.wrap
    ).provideEnvironment(r)
    def deleteImage(
        request: DeleteImageRequest
    ): IO[AwsError, zio.aws.imagebuilder.model.DeleteImageResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.imagebuilder.model.DeleteImageRequest,
        DeleteImageResponse
      ]("deleteImage", api.deleteImage)(request.buildAwsValue())
        .map(zio.aws.imagebuilder.model.DeleteImageResponse.wrap)
        .provideEnvironment(r)
    def createImageRecipe(request: CreateImageRecipeRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.CreateImageRecipeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.CreateImageRecipeRequest,
      CreateImageRecipeResponse
    ]("createImageRecipe", api.createImageRecipe)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.CreateImageRecipeResponse.wrap)
      .provideEnvironment(r)
    def listComponentBuildVersions(
        request: ListComponentBuildVersionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.ComponentSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsRequest,
      ComponentSummary,
      ListComponentBuildVersionsPublisher
    ](
      "listComponentBuildVersions",
      api.listComponentBuildVersionsPaginator,
      _.componentSummaryList()
    )(request.buildAwsValue())
      .map(item => zio.aws.imagebuilder.model.ComponentSummary.wrap(item))
      .provideEnvironment(r)
    def listComponentBuildVersionsPaginated(
        request: ListComponentBuildVersionsRequest
    ): IO[
      AwsError,
      zio.aws.imagebuilder.model.ListComponentBuildVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsRequest,
      ListComponentBuildVersionsResponse
    ]("listComponentBuildVersions", api.listComponentBuildVersions)(
      request.buildAwsValue()
    ).map(zio.aws.imagebuilder.model.ListComponentBuildVersionsResponse.wrap)
      .provideEnvironment(r)
    def putImagePolicy(request: PutImagePolicyRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.PutImagePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.PutImagePolicyRequest,
      PutImagePolicyResponse
    ]("putImagePolicy", api.putImagePolicy)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.PutImagePolicyResponse.wrap)
      .provideEnvironment(r)
    def getDistributionConfiguration(
        request: GetDistributionConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.imagebuilder.model.GetDistributionConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.GetDistributionConfigurationRequest,
      GetDistributionConfigurationResponse
    ]("getDistributionConfiguration", api.getDistributionConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.imagebuilder.model.GetDistributionConfigurationResponse.wrap)
      .provideEnvironment(r)
    def deleteImageRecipe(request: DeleteImageRecipeRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.DeleteImageRecipeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.DeleteImageRecipeRequest,
      DeleteImageRecipeResponse
    ]("deleteImageRecipe", api.deleteImageRecipe)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.DeleteImageRecipeResponse.wrap)
      .provideEnvironment(r)
    def createContainerRecipe(request: CreateContainerRecipeRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.CreateContainerRecipeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.CreateContainerRecipeRequest,
      CreateContainerRecipeResponse
    ]("createContainerRecipe", api.createContainerRecipe)(
      request.buildAwsValue()
    ).map(zio.aws.imagebuilder.model.CreateContainerRecipeResponse.wrap)
      .provideEnvironment(r)
    def deleteDistributionConfiguration(
        request: DeleteDistributionConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.imagebuilder.model.DeleteDistributionConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.DeleteDistributionConfigurationRequest,
      DeleteDistributionConfigurationResponse
    ]("deleteDistributionConfiguration", api.deleteDistributionConfiguration)(
      request.buildAwsValue()
    ).map(
      zio.aws.imagebuilder.model.DeleteDistributionConfigurationResponse.wrap
    ).provideEnvironment(r)
    def putContainerRecipePolicy(request: PutContainerRecipePolicyRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.PutContainerRecipePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.PutContainerRecipePolicyRequest,
      PutContainerRecipePolicyResponse
    ]("putContainerRecipePolicy", api.putContainerRecipePolicy)(
      request.buildAwsValue()
    ).map(zio.aws.imagebuilder.model.PutContainerRecipePolicyResponse.wrap)
      .provideEnvironment(r)
    def createInfrastructureConfiguration(
        request: CreateInfrastructureConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.imagebuilder.model.CreateInfrastructureConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.CreateInfrastructureConfigurationRequest,
      CreateInfrastructureConfigurationResponse
    ](
      "createInfrastructureConfiguration",
      api.createInfrastructureConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.imagebuilder.model.CreateInfrastructureConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def listComponents(request: ListComponentsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.ComponentVersion.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.imagebuilder.model.ListComponentsRequest,
      ComponentVersion,
      ListComponentsPublisher
    ]("listComponents", api.listComponentsPaginator, _.componentVersionList())(
      request.buildAwsValue()
    ).map(item => zio.aws.imagebuilder.model.ComponentVersion.wrap(item))
      .provideEnvironment(r)
    def listComponentsPaginated(request: ListComponentsRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.ListComponentsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.ListComponentsRequest,
      ListComponentsResponse
    ]("listComponents", api.listComponents)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.ListComponentsResponse.wrap)
      .provideEnvironment(r)
    def createImage(
        request: CreateImageRequest
    ): IO[AwsError, zio.aws.imagebuilder.model.CreateImageResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.imagebuilder.model.CreateImageRequest,
        CreateImageResponse
      ]("createImage", api.createImage)(request.buildAwsValue())
        .map(zio.aws.imagebuilder.model.CreateImageResponse.wrap)
        .provideEnvironment(r)
    def deleteInfrastructureConfiguration(
        request: DeleteInfrastructureConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.imagebuilder.model.DeleteInfrastructureConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.DeleteInfrastructureConfigurationRequest,
      DeleteInfrastructureConfigurationResponse
    ](
      "deleteInfrastructureConfiguration",
      api.deleteInfrastructureConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.imagebuilder.model.DeleteInfrastructureConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.imagebuilder.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.imagebuilder.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.imagebuilder.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def deleteComponent(request: DeleteComponentRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.DeleteComponentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.DeleteComponentRequest,
      DeleteComponentResponse
    ]("deleteComponent", api.deleteComponent)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.DeleteComponentResponse.wrap)
      .provideEnvironment(r)
    def listImagePipelines(request: ListImagePipelinesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.ImagePipeline.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.imagebuilder.model.ListImagePipelinesRequest,
      ImagePipeline,
      ListImagePipelinesPublisher
    ](
      "listImagePipelines",
      api.listImagePipelinesPaginator,
      _.imagePipelineList()
    )(request.buildAwsValue())
      .map(item => zio.aws.imagebuilder.model.ImagePipeline.wrap(item))
      .provideEnvironment(r)
    def listImagePipelinesPaginated(request: ListImagePipelinesRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.ListImagePipelinesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.ListImagePipelinesRequest,
      ListImagePipelinesResponse
    ]("listImagePipelines", api.listImagePipelines)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.ListImagePipelinesResponse.wrap)
      .provideEnvironment(r)
    def listDistributionConfigurations(
        request: ListDistributionConfigurationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.DistributionConfigurationSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsRequest,
      DistributionConfigurationSummary,
      ListDistributionConfigurationsPublisher
    ](
      "listDistributionConfigurations",
      api.listDistributionConfigurationsPaginator,
      _.distributionConfigurationSummaryList()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.imagebuilder.model.DistributionConfigurationSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listDistributionConfigurationsPaginated(
        request: ListDistributionConfigurationsRequest
    ): IO[
      AwsError,
      zio.aws.imagebuilder.model.ListDistributionConfigurationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.ListDistributionConfigurationsRequest,
      ListDistributionConfigurationsResponse
    ]("listDistributionConfigurations", api.listDistributionConfigurations)(
      request.buildAwsValue()
    ).map(
      zio.aws.imagebuilder.model.ListDistributionConfigurationsResponse.wrap
    ).provideEnvironment(r)
    def getContainerRecipePolicy(request: GetContainerRecipePolicyRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.GetContainerRecipePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.GetContainerRecipePolicyRequest,
      GetContainerRecipePolicyResponse
    ]("getContainerRecipePolicy", api.getContainerRecipePolicy)(
      request.buildAwsValue()
    ).map(zio.aws.imagebuilder.model.GetContainerRecipePolicyResponse.wrap)
      .provideEnvironment(r)
    def listImagePipelineImages(
        request: ListImagePipelineImagesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.ImageSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.imagebuilder.model.ListImagePipelineImagesRequest,
      ImageSummary,
      ListImagePipelineImagesPublisher
    ](
      "listImagePipelineImages",
      api.listImagePipelineImagesPaginator,
      _.imageSummaryList()
    )(request.buildAwsValue())
      .map(item => zio.aws.imagebuilder.model.ImageSummary.wrap(item))
      .provideEnvironment(r)
    def listImagePipelineImagesPaginated(
        request: ListImagePipelineImagesRequest
    ): IO[
      AwsError,
      zio.aws.imagebuilder.model.ListImagePipelineImagesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.ListImagePipelineImagesRequest,
      ListImagePipelineImagesResponse
    ]("listImagePipelineImages", api.listImagePipelineImages)(
      request.buildAwsValue()
    ).map(zio.aws.imagebuilder.model.ListImagePipelineImagesResponse.wrap)
      .provideEnvironment(r)
    def createDistributionConfiguration(
        request: CreateDistributionConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.imagebuilder.model.CreateDistributionConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.CreateDistributionConfigurationRequest,
      CreateDistributionConfigurationResponse
    ]("createDistributionConfiguration", api.createDistributionConfiguration)(
      request.buildAwsValue()
    ).map(
      zio.aws.imagebuilder.model.CreateDistributionConfigurationResponse.wrap
    ).provideEnvironment(r)
    def importComponent(request: ImportComponentRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.ImportComponentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.ImportComponentRequest,
      ImportComponentResponse
    ]("importComponent", api.importComponent)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.ImportComponentResponse.wrap)
      .provideEnvironment(r)
    def createComponent(request: CreateComponentRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.CreateComponentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.CreateComponentRequest,
      CreateComponentResponse
    ]("createComponent", api.createComponent)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.CreateComponentResponse.wrap)
      .provideEnvironment(r)
    def getImagePipeline(request: GetImagePipelineRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.GetImagePipelineResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.GetImagePipelineRequest,
      GetImagePipelineResponse
    ]("getImagePipeline", api.getImagePipeline)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.GetImagePipelineResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.imagebuilder.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.imagebuilder.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.imagebuilder.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def createImagePipeline(request: CreateImagePipelineRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.CreateImagePipelineResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.CreateImagePipelineRequest,
      CreateImagePipelineResponse
    ]("createImagePipeline", api.createImagePipeline)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.CreateImagePipelineResponse.wrap)
      .provideEnvironment(r)
    def listInfrastructureConfigurations(
        request: ListInfrastructureConfigurationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.InfrastructureConfigurationSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.imagebuilder.model.ListInfrastructureConfigurationsRequest,
      InfrastructureConfigurationSummary,
      ListInfrastructureConfigurationsPublisher
    ](
      "listInfrastructureConfigurations",
      api.listInfrastructureConfigurationsPaginator,
      _.infrastructureConfigurationSummaryList()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.imagebuilder.model.InfrastructureConfigurationSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listInfrastructureConfigurationsPaginated(
        request: ListInfrastructureConfigurationsRequest
    ): IO[
      AwsError,
      zio.aws.imagebuilder.model.ListInfrastructureConfigurationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.ListInfrastructureConfigurationsRequest,
      ListInfrastructureConfigurationsResponse
    ]("listInfrastructureConfigurations", api.listInfrastructureConfigurations)(
      request.buildAwsValue()
    ).map(
      zio.aws.imagebuilder.model.ListInfrastructureConfigurationsResponse.wrap
    ).provideEnvironment(r)
    def getInfrastructureConfiguration(
        request: GetInfrastructureConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.imagebuilder.model.GetInfrastructureConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.GetInfrastructureConfigurationRequest,
      GetInfrastructureConfigurationResponse
    ]("getInfrastructureConfiguration", api.getInfrastructureConfiguration)(
      request.buildAwsValue()
    ).map(
      zio.aws.imagebuilder.model.GetInfrastructureConfigurationResponse.wrap
    ).provideEnvironment(r)
    def deleteContainerRecipe(request: DeleteContainerRecipeRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.DeleteContainerRecipeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.DeleteContainerRecipeRequest,
      DeleteContainerRecipeResponse
    ]("deleteContainerRecipe", api.deleteContainerRecipe)(
      request.buildAwsValue()
    ).map(zio.aws.imagebuilder.model.DeleteContainerRecipeResponse.wrap)
      .provideEnvironment(r)
    def getImage(
        request: GetImageRequest
    ): IO[AwsError, zio.aws.imagebuilder.model.GetImageResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.imagebuilder.model.GetImageRequest,
        GetImageResponse
      ]("getImage", api.getImage)(request.buildAwsValue())
        .map(zio.aws.imagebuilder.model.GetImageResponse.wrap)
        .provideEnvironment(r)
    def listContainerRecipes(request: ListContainerRecipesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.ContainerRecipeSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesRequest,
      ContainerRecipeSummary,
      ListContainerRecipesPublisher
    ](
      "listContainerRecipes",
      api.listContainerRecipesPaginator,
      _.containerRecipeSummaryList()
    )(request.buildAwsValue())
      .map(item => zio.aws.imagebuilder.model.ContainerRecipeSummary.wrap(item))
      .provideEnvironment(r)
    def listContainerRecipesPaginated(request: ListContainerRecipesRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.ListContainerRecipesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesRequest,
      ListContainerRecipesResponse
    ]("listContainerRecipes", api.listContainerRecipes)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.ListContainerRecipesResponse.wrap)
      .provideEnvironment(r)
    def deleteImagePipeline(request: DeleteImagePipelineRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.DeleteImagePipelineResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.DeleteImagePipelineRequest,
      DeleteImagePipelineResponse
    ]("deleteImagePipeline", api.deleteImagePipeline)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.DeleteImagePipelineResponse.wrap)
      .provideEnvironment(r)
    def putImageRecipePolicy(request: PutImageRecipePolicyRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.PutImageRecipePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.PutImageRecipePolicyRequest,
      PutImageRecipePolicyResponse
    ]("putImageRecipePolicy", api.putImageRecipePolicy)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.PutImageRecipePolicyResponse.wrap)
      .provideEnvironment(r)
    def updateImagePipeline(
        request: UpdateImagePipelineRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.UpdateImagePipelineRequest,
      UpdateImagePipelineResponse
    ]("updateImagePipeline", api.updateImagePipeline)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.UpdateImagePipelineResponse.wrap)
      .provideEnvironment(r)
    def getImageRecipePolicy(request: GetImageRecipePolicyRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.GetImageRecipePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.GetImageRecipePolicyRequest,
      GetImageRecipePolicyResponse
    ]("getImageRecipePolicy", api.getImageRecipePolicy)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.GetImageRecipePolicyResponse.wrap)
      .provideEnvironment(r)
    def listImageBuildVersions(request: ListImageBuildVersionsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.ImageSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsRequest,
      ImageSummary,
      ListImageBuildVersionsPublisher
    ](
      "listImageBuildVersions",
      api.listImageBuildVersionsPaginator,
      _.imageSummaryList()
    )(request.buildAwsValue())
      .map(item => zio.aws.imagebuilder.model.ImageSummary.wrap(item))
      .provideEnvironment(r)
    def listImageBuildVersionsPaginated(
        request: ListImageBuildVersionsRequest
    ): IO[
      AwsError,
      zio.aws.imagebuilder.model.ListImageBuildVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsRequest,
      ListImageBuildVersionsResponse
    ]("listImageBuildVersions", api.listImageBuildVersions)(
      request.buildAwsValue()
    ).map(zio.aws.imagebuilder.model.ListImageBuildVersionsResponse.wrap)
      .provideEnvironment(r)
    def updateInfrastructureConfiguration(
        request: UpdateInfrastructureConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.imagebuilder.model.UpdateInfrastructureConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.UpdateInfrastructureConfigurationRequest,
      UpdateInfrastructureConfigurationResponse
    ](
      "updateInfrastructureConfiguration",
      api.updateInfrastructureConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.imagebuilder.model.UpdateInfrastructureConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def getComponent(
        request: GetComponentRequest
    ): IO[AwsError, zio.aws.imagebuilder.model.GetComponentResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.imagebuilder.model.GetComponentRequest,
        GetComponentResponse
      ]("getComponent", api.getComponent)(request.buildAwsValue())
        .map(zio.aws.imagebuilder.model.GetComponentResponse.wrap)
        .provideEnvironment(r)
    def importVmImage(
        request: ImportVmImageRequest
    ): IO[AwsError, zio.aws.imagebuilder.model.ImportVmImageResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.imagebuilder.model.ImportVmImageRequest,
        ImportVmImageResponse
      ]("importVmImage", api.importVmImage)(request.buildAwsValue())
        .map(zio.aws.imagebuilder.model.ImportVmImageResponse.wrap)
        .provideEnvironment(r)
    def cancelImageCreation(request: CancelImageCreationRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.CancelImageCreationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.CancelImageCreationRequest,
      CancelImageCreationResponse
    ]("cancelImageCreation", api.cancelImageCreation)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.CancelImageCreationResponse.wrap)
      .provideEnvironment(r)
    def getImagePolicy(request: GetImagePolicyRequest): IO[
      AwsError,
      zio.aws.imagebuilder.model.GetImagePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.imagebuilder.model.GetImagePolicyRequest,
      GetImagePolicyResponse
    ]("getImagePolicy", api.getImagePolicy)(request.buildAwsValue())
      .map(zio.aws.imagebuilder.model.GetImagePolicyResponse.wrap)
      .provideEnvironment(r)
  }
  def listImages(request: ListImagesRequest): ZStream[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ImageVersion.ReadOnly
  ] = ZStream.serviceWithStream(_.listImages(request))
  def listImagesPaginated(request: ListImagesRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ListImagesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listImagesPaginated(request))
  def listImageRecipes(request: ListImageRecipesRequest): ZStream[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ImageRecipeSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listImageRecipes(request))
  def listImageRecipesPaginated(request: ListImageRecipesRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ListImageRecipesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listImageRecipesPaginated(request))
  def putComponentPolicy(request: PutComponentPolicyRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.PutComponentPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putComponentPolicy(request))
  def getImageRecipe(request: GetImageRecipeRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.GetImageRecipeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getImageRecipe(request))
  def listImagePackages(request: ListImagePackagesRequest): ZStream[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ImagePackage.ReadOnly
  ] = ZStream.serviceWithStream(_.listImagePackages(request))
  def listImagePackagesPaginated(request: ListImagePackagesRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ListImagePackagesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listImagePackagesPaginated(request))
  def getComponentPolicy(request: GetComponentPolicyRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.GetComponentPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getComponentPolicy(request))
  def getContainerRecipe(request: GetContainerRecipeRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.GetContainerRecipeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getContainerRecipe(request))
  def startImagePipelineExecution(
      request: StartImagePipelineExecutionRequest
  ): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.StartImagePipelineExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startImagePipelineExecution(request))
  def updateDistributionConfiguration(
      request: UpdateDistributionConfigurationRequest
  ): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.UpdateDistributionConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDistributionConfiguration(request))
  def deleteImage(request: DeleteImageRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.DeleteImageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteImage(request))
  def createImageRecipe(request: CreateImageRecipeRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.CreateImageRecipeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createImageRecipe(request))
  def listComponentBuildVersions(
      request: ListComponentBuildVersionsRequest
  ): ZStream[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ComponentSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listComponentBuildVersions(request))
  def listComponentBuildVersionsPaginated(
      request: ListComponentBuildVersionsRequest
  ): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ListComponentBuildVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listComponentBuildVersionsPaginated(request))
  def putImagePolicy(request: PutImagePolicyRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.PutImagePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putImagePolicy(request))
  def getDistributionConfiguration(
      request: GetDistributionConfigurationRequest
  ): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.GetDistributionConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDistributionConfiguration(request))
  def deleteImageRecipe(request: DeleteImageRecipeRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.DeleteImageRecipeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteImageRecipe(request))
  def createContainerRecipe(request: CreateContainerRecipeRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.CreateContainerRecipeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createContainerRecipe(request))
  def deleteDistributionConfiguration(
      request: DeleteDistributionConfigurationRequest
  ): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.DeleteDistributionConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDistributionConfiguration(request))
  def putContainerRecipePolicy(request: PutContainerRecipePolicyRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.PutContainerRecipePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putContainerRecipePolicy(request))
  def createInfrastructureConfiguration(
      request: CreateInfrastructureConfigurationRequest
  ): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.CreateInfrastructureConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createInfrastructureConfiguration(request))
  def listComponents(request: ListComponentsRequest): ZStream[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ComponentVersion.ReadOnly
  ] = ZStream.serviceWithStream(_.listComponents(request))
  def listComponentsPaginated(request: ListComponentsRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ListComponentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listComponentsPaginated(request))
  def createImage(request: CreateImageRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.CreateImageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createImage(request))
  def deleteInfrastructureConfiguration(
      request: DeleteInfrastructureConfigurationRequest
  ): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.DeleteInfrastructureConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteInfrastructureConfiguration(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def deleteComponent(request: DeleteComponentRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.DeleteComponentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteComponent(request))
  def listImagePipelines(request: ListImagePipelinesRequest): ZStream[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ImagePipeline.ReadOnly
  ] = ZStream.serviceWithStream(_.listImagePipelines(request))
  def listImagePipelinesPaginated(request: ListImagePipelinesRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ListImagePipelinesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listImagePipelinesPaginated(request))
  def listDistributionConfigurations(
      request: ListDistributionConfigurationsRequest
  ): ZStream[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.DistributionConfigurationSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listDistributionConfigurations(request))
  def listDistributionConfigurationsPaginated(
      request: ListDistributionConfigurationsRequest
  ): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ListDistributionConfigurationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDistributionConfigurationsPaginated(request))
  def getContainerRecipePolicy(request: GetContainerRecipePolicyRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.GetContainerRecipePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getContainerRecipePolicy(request))
  def listImagePipelineImages(request: ListImagePipelineImagesRequest): ZStream[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ImageSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listImagePipelineImages(request))
  def listImagePipelineImagesPaginated(
      request: ListImagePipelineImagesRequest
  ): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ListImagePipelineImagesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listImagePipelineImagesPaginated(request))
  def createDistributionConfiguration(
      request: CreateDistributionConfigurationRequest
  ): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.CreateDistributionConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDistributionConfiguration(request))
  def importComponent(request: ImportComponentRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ImportComponentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.importComponent(request))
  def createComponent(request: CreateComponentRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.CreateComponentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createComponent(request))
  def getImagePipeline(request: GetImagePipelineRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.GetImagePipelineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getImagePipeline(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def createImagePipeline(request: CreateImagePipelineRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.CreateImagePipelineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createImagePipeline(request))
  def listInfrastructureConfigurations(
      request: ListInfrastructureConfigurationsRequest
  ): ZStream[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.InfrastructureConfigurationSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listInfrastructureConfigurations(request))
  def listInfrastructureConfigurationsPaginated(
      request: ListInfrastructureConfigurationsRequest
  ): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ListInfrastructureConfigurationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listInfrastructureConfigurationsPaginated(request))
  def getInfrastructureConfiguration(
      request: GetInfrastructureConfigurationRequest
  ): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.GetInfrastructureConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getInfrastructureConfiguration(request))
  def deleteContainerRecipe(request: DeleteContainerRecipeRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.DeleteContainerRecipeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteContainerRecipe(request))
  def getImage(request: GetImageRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.GetImageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getImage(request))
  def listContainerRecipes(request: ListContainerRecipesRequest): ZStream[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ContainerRecipeSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listContainerRecipes(request))
  def listContainerRecipesPaginated(request: ListContainerRecipesRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ListContainerRecipesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listContainerRecipesPaginated(request))
  def deleteImagePipeline(request: DeleteImagePipelineRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.DeleteImagePipelineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteImagePipeline(request))
  def putImageRecipePolicy(request: PutImageRecipePolicyRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.PutImageRecipePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putImageRecipePolicy(request))
  def updateImagePipeline(
      request: UpdateImagePipelineRequest
  ): ZIO[zio.aws.imagebuilder.Imagebuilder, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.updateImagePipeline(request))
  def getImageRecipePolicy(request: GetImageRecipePolicyRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.GetImageRecipePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getImageRecipePolicy(request))
  def listImageBuildVersions(request: ListImageBuildVersionsRequest): ZStream[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ImageSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listImageBuildVersions(request))
  def listImageBuildVersionsPaginated(
      request: ListImageBuildVersionsRequest
  ): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ListImageBuildVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listImageBuildVersionsPaginated(request))
  def updateInfrastructureConfiguration(
      request: UpdateInfrastructureConfigurationRequest
  ): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.UpdateInfrastructureConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateInfrastructureConfiguration(request))
  def getComponent(request: GetComponentRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.GetComponentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getComponent(request))
  def importVmImage(request: ImportVmImageRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.ImportVmImageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.importVmImage(request))
  def cancelImageCreation(request: CancelImageCreationRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.CancelImageCreationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelImageCreation(request))
  def getImagePolicy(request: GetImagePolicyRequest): ZIO[
    zio.aws.imagebuilder.Imagebuilder,
    AwsError,
    zio.aws.imagebuilder.model.GetImagePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getImagePolicy(request))
}
