package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  ImageBuilderArn,
  TagValue,
  DateTime,
  VersionNumber,
  OsVersion,
  NonEmptyString,
  ResourceName,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ImageSummary(
    arn: Optional[ImageBuilderArn] = Optional.Absent,
    name: Optional[ResourceName] = Optional.Absent,
    `type`: Optional[zio.aws.imagebuilder.model.ImageType] = Optional.Absent,
    version: Optional[VersionNumber] = Optional.Absent,
    platform: Optional[zio.aws.imagebuilder.model.Platform] = Optional.Absent,
    osVersion: Optional[OsVersion] = Optional.Absent,
    state: Optional[zio.aws.imagebuilder.model.ImageState] = Optional.Absent,
    owner: Optional[NonEmptyString] = Optional.Absent,
    dateCreated: Optional[DateTime] = Optional.Absent,
    outputResources: Optional[zio.aws.imagebuilder.model.OutputResources] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    buildType: Optional[zio.aws.imagebuilder.model.BuildType] = Optional.Absent,
    imageSource: Optional[zio.aws.imagebuilder.model.ImageSource] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ImageSummary = {
    import ImageSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ImageSummary
      .builder()
      .optionallyWith(
        arn.map(value => ImageBuilderArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        version.map(value => VersionNumber.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .optionallyWith(
        osVersion.map(value => OsVersion.unwrap(value): java.lang.String)
      )(_.osVersion)
      .optionallyWith(state.map(value => value.buildAwsValue()))(_.state)
      .optionallyWith(
        owner.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.owner)
      .optionallyWith(
        dateCreated.map(value => DateTime.unwrap(value): java.lang.String)
      )(_.dateCreated)
      .optionallyWith(outputResources.map(value => value.buildAwsValue()))(
        _.outputResources
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(buildType.map(value => value.unwrap))(_.buildType)
      .optionallyWith(imageSource.map(value => value.unwrap))(_.imageSource)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.ImageSummary.ReadOnly =
    zio.aws.imagebuilder.model.ImageSummary.wrap(buildAwsValue())
}
object ImageSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ImageSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ImageSummary =
      zio.aws.imagebuilder.model.ImageSummary(
        arn.map(value => value),
        name.map(value => value),
        `type`.map(value => value),
        version.map(value => value),
        platform.map(value => value),
        osVersion.map(value => value),
        state.map(value => value.asEditable),
        owner.map(value => value),
        dateCreated.map(value => value),
        outputResources.map(value => value.asEditable),
        tags.map(value => value),
        buildType.map(value => value),
        imageSource.map(value => value)
      )
    def arn: Optional[ImageBuilderArn]
    def name: Optional[ResourceName]
    def `type`: Optional[zio.aws.imagebuilder.model.ImageType]
    def version: Optional[VersionNumber]
    def platform: Optional[zio.aws.imagebuilder.model.Platform]
    def osVersion: Optional[OsVersion]
    def state: Optional[zio.aws.imagebuilder.model.ImageState.ReadOnly]
    def owner: Optional[NonEmptyString]
    def dateCreated: Optional[DateTime]
    def outputResources
        : Optional[zio.aws.imagebuilder.model.OutputResources.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def buildType: Optional[zio.aws.imagebuilder.model.BuildType]
    def imageSource: Optional[zio.aws.imagebuilder.model.ImageSource]
    def getArn: ZIO[Any, AwsError, ImageBuilderArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, zio.aws.imagebuilder.model.ImageType] =
      AwsError.unwrapOptionField("type", `type`)
    def getVersion: ZIO[Any, AwsError, VersionNumber] =
      AwsError.unwrapOptionField("version", version)
    def getPlatform: ZIO[Any, AwsError, zio.aws.imagebuilder.model.Platform] =
      AwsError.unwrapOptionField("platform", platform)
    def getOsVersion: ZIO[Any, AwsError, OsVersion] =
      AwsError.unwrapOptionField("osVersion", osVersion)
    def getState
        : ZIO[Any, AwsError, zio.aws.imagebuilder.model.ImageState.ReadOnly] =
      AwsError.unwrapOptionField("state", state)
    def getOwner: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("owner", owner)
    def getDateCreated: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("dateCreated", dateCreated)
    def getOutputResources: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.OutputResources.ReadOnly
    ] = AwsError.unwrapOptionField("outputResources", outputResources)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getBuildType: ZIO[Any, AwsError, zio.aws.imagebuilder.model.BuildType] =
      AwsError.unwrapOptionField("buildType", buildType)
    def getImageSource
        : ZIO[Any, AwsError, zio.aws.imagebuilder.model.ImageSource] =
      AwsError.unwrapOptionField("imageSource", imageSource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ImageSummary
  ) extends zio.aws.imagebuilder.model.ImageSummary.ReadOnly {
    override val arn: Optional[ImageBuilderArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.ImageBuilderArn(value)
      )
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.imagebuilder.model.primitives.ResourceName(value))
    override val `type`: Optional[zio.aws.imagebuilder.model.ImageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.imagebuilder.model.ImageType.wrap(value))
    override val version: Optional[VersionNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.imagebuilder.model.primitives.VersionNumber(value))
    override val platform: Optional[zio.aws.imagebuilder.model.Platform] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platform())
        .map(value => zio.aws.imagebuilder.model.Platform.wrap(value))
    override val osVersion: Optional[OsVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.osVersion())
      .map(value => zio.aws.imagebuilder.model.primitives.OsVersion(value))
    override val state
        : Optional[zio.aws.imagebuilder.model.ImageState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.imagebuilder.model.ImageState.wrap(value))
    override val owner: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.owner())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val dateCreated: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.dateCreated())
      .map(value => zio.aws.imagebuilder.model.primitives.DateTime(value))
    override val outputResources
        : Optional[zio.aws.imagebuilder.model.OutputResources.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputResources())
        .map(value => zio.aws.imagebuilder.model.OutputResources.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.imagebuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.imagebuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val buildType: Optional[zio.aws.imagebuilder.model.BuildType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.buildType())
        .map(value => zio.aws.imagebuilder.model.BuildType.wrap(value))
    override val imageSource: Optional[zio.aws.imagebuilder.model.ImageSource] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageSource())
        .map(value => zio.aws.imagebuilder.model.ImageSource.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ImageSummary
  ): zio.aws.imagebuilder.model.ImageSummary.ReadOnly = new Wrapper(impl)
}
