package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  AccountId,
  TagValue,
  AmiNameString,
  NonEmptyString,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AmiDistributionConfiguration(
    name: Optional[AmiNameString] = Optional.Absent,
    description: Optional[NonEmptyString] = Optional.Absent,
    targetAccountIds: Optional[Iterable[AccountId]] = Optional.Absent,
    amiTags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    kmsKeyId: Optional[NonEmptyString] = Optional.Absent,
    launchPermission: Optional[
      zio.aws.imagebuilder.model.LaunchPermissionConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.AmiDistributionConfiguration = {
    import AmiDistributionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.AmiDistributionConfiguration
      .builder()
      .optionallyWith(
        name.map(value => AmiNameString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        targetAccountIds.map(value =>
          value.map { item =>
            AccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.targetAccountIds)
      .optionallyWith(
        amiTags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.amiTags)
      .optionallyWith(
        kmsKeyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(launchPermission.map(value => value.buildAwsValue()))(
        _.launchPermission
      )
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.AmiDistributionConfiguration.ReadOnly =
    zio.aws.imagebuilder.model.AmiDistributionConfiguration
      .wrap(buildAwsValue())
}
object AmiDistributionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.AmiDistributionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.AmiDistributionConfiguration =
      zio.aws.imagebuilder.model.AmiDistributionConfiguration(
        name.map(value => value),
        description.map(value => value),
        targetAccountIds.map(value => value),
        amiTags.map(value => value),
        kmsKeyId.map(value => value),
        launchPermission.map(value => value.asEditable)
      )
    def name: Optional[AmiNameString]
    def description: Optional[NonEmptyString]
    def targetAccountIds: Optional[List[AccountId]]
    def amiTags: Optional[Map[TagKey, TagValue]]
    def kmsKeyId: Optional[NonEmptyString]
    def launchPermission: Optional[
      zio.aws.imagebuilder.model.LaunchPermissionConfiguration.ReadOnly
    ]
    def getName: ZIO[Any, AwsError, AmiNameString] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getTargetAccountIds: ZIO[Any, AwsError, List[AccountId]] =
      AwsError.unwrapOptionField("targetAccountIds", targetAccountIds)
    def getAmiTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("amiTags", amiTags)
    def getKmsKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getLaunchPermission: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.LaunchPermissionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("launchPermission", launchPermission)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.AmiDistributionConfiguration
  ) extends zio.aws.imagebuilder.model.AmiDistributionConfiguration.ReadOnly {
    override val name: Optional[AmiNameString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.imagebuilder.model.primitives.AmiNameString(value))
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val targetAccountIds: Optional[List[AccountId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetAccountIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.imagebuilder.model.primitives.AccountId(item)
          }.toList
        )
    override val amiTags: Optional[Map[TagKey, TagValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.amiTags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.imagebuilder.model.primitives.TagKey(
                key
              ) -> zio.aws.imagebuilder.model.primitives.TagValue(value)
            })
            .toMap
        )
    override val kmsKeyId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val launchPermission: Optional[
      zio.aws.imagebuilder.model.LaunchPermissionConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.launchPermission())
      .map(value =>
        zio.aws.imagebuilder.model.LaunchPermissionConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.AmiDistributionConfiguration
  ): zio.aws.imagebuilder.model.AmiDistributionConfiguration.ReadOnly =
    new Wrapper(impl)
}
