package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.ImageBuilderArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(resourceArn: ImageBuilderArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(ImageBuilderArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.imagebuilder.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ListTagsForResourceRequest =
      zio.aws.imagebuilder.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: ImageBuilderArn
    def getResourceArn: ZIO[Any, Nothing, ImageBuilderArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListTagsForResourceRequest
  ) extends zio.aws.imagebuilder.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: ImageBuilderArn =
      zio.aws.imagebuilder.model.primitives.ImageBuilderArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListTagsForResourceRequest
  ): zio.aws.imagebuilder.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
