package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{ImageRecipeArn, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutImageRecipePolicyResponse(
    requestId: Optional[NonEmptyString] = Optional.Absent,
    imageRecipeArn: Optional[ImageRecipeArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.PutImageRecipePolicyResponse = {
    import PutImageRecipePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.PutImageRecipePolicyResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        imageRecipeArn.map(value =>
          ImageRecipeArn.unwrap(value): java.lang.String
        )
      )(_.imageRecipeArn)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.PutImageRecipePolicyResponse.ReadOnly =
    zio.aws.imagebuilder.model.PutImageRecipePolicyResponse
      .wrap(buildAwsValue())
}
object PutImageRecipePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.PutImageRecipePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.PutImageRecipePolicyResponse =
      zio.aws.imagebuilder.model.PutImageRecipePolicyResponse(
        requestId.map(value => value),
        imageRecipeArn.map(value => value)
      )
    def requestId: Optional[NonEmptyString]
    def imageRecipeArn: Optional[ImageRecipeArn]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getImageRecipeArn: ZIO[Any, AwsError, ImageRecipeArn] =
      AwsError.unwrapOptionField("imageRecipeArn", imageRecipeArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.PutImageRecipePolicyResponse
  ) extends zio.aws.imagebuilder.model.PutImageRecipePolicyResponse.ReadOnly {
    override val requestId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val imageRecipeArn: Optional[ImageRecipeArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageRecipeArn())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.ImageRecipeArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.PutImageRecipePolicyResponse
  ): zio.aws.imagebuilder.model.PutImageRecipePolicyResponse.ReadOnly =
    new Wrapper(impl)
}
