package zio.aws.imagebuilder.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.imagebuilder.model.primitives.TargetResourceCount
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class FastLaunchSnapshotConfiguration(
    targetResourceCount: Optional[TargetResourceCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.FastLaunchSnapshotConfiguration = {
    import FastLaunchSnapshotConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.FastLaunchSnapshotConfiguration
      .builder()
      .optionallyWith(
        targetResourceCount.map(value =>
          TargetResourceCount.unwrap(value): Integer
        )
      )(_.targetResourceCount)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.FastLaunchSnapshotConfiguration.ReadOnly =
    zio.aws.imagebuilder.model.FastLaunchSnapshotConfiguration
      .wrap(buildAwsValue())
}
object FastLaunchSnapshotConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.FastLaunchSnapshotConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.FastLaunchSnapshotConfiguration =
      zio.aws.imagebuilder.model.FastLaunchSnapshotConfiguration(
        targetResourceCount.map(value => value)
      )
    def targetResourceCount: Optional[TargetResourceCount]
    def getTargetResourceCount: ZIO[Any, AwsError, TargetResourceCount] =
      AwsError.unwrapOptionField("targetResourceCount", targetResourceCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.FastLaunchSnapshotConfiguration
  ) extends zio.aws.imagebuilder.model.FastLaunchSnapshotConfiguration.ReadOnly {
    override val targetResourceCount: Optional[TargetResourceCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetResourceCount())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.TargetResourceCount(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.FastLaunchSnapshotConfiguration
  ): zio.aws.imagebuilder.model.FastLaunchSnapshotConfiguration.ReadOnly =
    new Wrapper(impl)
}
