package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  ImageBuilderArn,
  TagValue,
  DateTime,
  VersionNumber,
  OsVersion,
  ComponentData,
  NullableBoolean,
  NonEmptyString,
  ResourceName,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Component(
    arn: Optional[ImageBuilderArn] = Optional.Absent,
    name: Optional[ResourceName] = Optional.Absent,
    version: Optional[VersionNumber] = Optional.Absent,
    description: Optional[NonEmptyString] = Optional.Absent,
    changeDescription: Optional[NonEmptyString] = Optional.Absent,
    `type`: Optional[zio.aws.imagebuilder.model.ComponentType] =
      Optional.Absent,
    platform: Optional[zio.aws.imagebuilder.model.Platform] = Optional.Absent,
    supportedOsVersions: Optional[Iterable[OsVersion]] = Optional.Absent,
    state: Optional[zio.aws.imagebuilder.model.ComponentState] =
      Optional.Absent,
    parameters: Optional[
      Iterable[zio.aws.imagebuilder.model.ComponentParameterDetail]
    ] = Optional.Absent,
    owner: Optional[NonEmptyString] = Optional.Absent,
    data: Optional[ComponentData] = Optional.Absent,
    kmsKeyId: Optional[NonEmptyString] = Optional.Absent,
    encrypted: Optional[NullableBoolean] = Optional.Absent,
    dateCreated: Optional[DateTime] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.Component = {
    import Component.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.Component
      .builder()
      .optionallyWith(
        arn.map(value => ImageBuilderArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        version.map(value => VersionNumber.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        changeDescription.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.changeDescription)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .optionallyWith(
        supportedOsVersions.map(value =>
          value.map { item =>
            OsVersion.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.supportedOsVersions)
      .optionallyWith(state.map(value => value.buildAwsValue()))(_.state)
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .optionallyWith(
        owner.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.owner)
      .optionallyWith(
        data.map(value => ComponentData.unwrap(value): java.lang.String)
      )(_.data)
      .optionallyWith(
        kmsKeyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(
        dateCreated.map(value => DateTime.unwrap(value): java.lang.String)
      )(_.dateCreated)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.Component.ReadOnly =
    zio.aws.imagebuilder.model.Component.wrap(buildAwsValue())
}
object Component {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.Component
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.Component =
      zio.aws.imagebuilder.model.Component(
        arn.map(value => value),
        name.map(value => value),
        version.map(value => value),
        description.map(value => value),
        changeDescription.map(value => value),
        `type`.map(value => value),
        platform.map(value => value),
        supportedOsVersions.map(value => value),
        state.map(value => value.asEditable),
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        owner.map(value => value),
        data.map(value => value),
        kmsKeyId.map(value => value),
        encrypted.map(value => value),
        dateCreated.map(value => value),
        tags.map(value => value)
      )
    def arn: Optional[ImageBuilderArn]
    def name: Optional[ResourceName]
    def version: Optional[VersionNumber]
    def description: Optional[NonEmptyString]
    def changeDescription: Optional[NonEmptyString]
    def `type`: Optional[zio.aws.imagebuilder.model.ComponentType]
    def platform: Optional[zio.aws.imagebuilder.model.Platform]
    def supportedOsVersions: Optional[List[OsVersion]]
    def state: Optional[zio.aws.imagebuilder.model.ComponentState.ReadOnly]
    def parameters: Optional[
      List[zio.aws.imagebuilder.model.ComponentParameterDetail.ReadOnly]
    ]
    def owner: Optional[NonEmptyString]
    def data: Optional[ComponentData]
    def kmsKeyId: Optional[NonEmptyString]
    def encrypted: Optional[NullableBoolean]
    def dateCreated: Optional[DateTime]
    def tags: Optional[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, AwsError, ImageBuilderArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getVersion: ZIO[Any, AwsError, VersionNumber] =
      AwsError.unwrapOptionField("version", version)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getChangeDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("changeDescription", changeDescription)
    def getType: ZIO[Any, AwsError, zio.aws.imagebuilder.model.ComponentType] =
      AwsError.unwrapOptionField("type", `type`)
    def getPlatform: ZIO[Any, AwsError, zio.aws.imagebuilder.model.Platform] =
      AwsError.unwrapOptionField("platform", platform)
    def getSupportedOsVersions: ZIO[Any, AwsError, List[OsVersion]] =
      AwsError.unwrapOptionField("supportedOsVersions", supportedOsVersions)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.ComponentState.ReadOnly
    ] = AwsError.unwrapOptionField("state", state)
    def getParameters: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.ComponentParameterDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getOwner: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("owner", owner)
    def getData: ZIO[Any, AwsError, ComponentData] =
      AwsError.unwrapOptionField("data", data)
    def getKmsKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getEncrypted: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getDateCreated: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("dateCreated", dateCreated)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.Component
  ) extends zio.aws.imagebuilder.model.Component.ReadOnly {
    override val arn: Optional[ImageBuilderArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.ImageBuilderArn(value)
      )
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.imagebuilder.model.primitives.ResourceName(value))
    override val version: Optional[VersionNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.imagebuilder.model.primitives.VersionNumber(value))
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val changeDescription: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.changeDescription())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.NonEmptyString(value)
        )
    override val `type`: Optional[zio.aws.imagebuilder.model.ComponentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.imagebuilder.model.ComponentType.wrap(value))
    override val platform: Optional[zio.aws.imagebuilder.model.Platform] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platform())
        .map(value => zio.aws.imagebuilder.model.Platform.wrap(value))
    override val supportedOsVersions: Optional[List[OsVersion]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedOsVersions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.imagebuilder.model.primitives.OsVersion(item)
          }.toList
        )
    override val state
        : Optional[zio.aws.imagebuilder.model.ComponentState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.imagebuilder.model.ComponentState.wrap(value))
    override val parameters: Optional[
      List[zio.aws.imagebuilder.model.ComponentParameterDetail.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.parameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.ComponentParameterDetail.wrap(item)
        }.toList
      )
    override val owner: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.owner())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val data: Optional[ComponentData] = zio.aws.core.internal
      .optionalFromNullable(impl.data())
      .map(value => zio.aws.imagebuilder.model.primitives.ComponentData(value))
    override val kmsKeyId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val encrypted: Optional[NullableBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.encrypted())
      .map(value => value: NullableBoolean)
    override val dateCreated: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.dateCreated())
      .map(value => zio.aws.imagebuilder.model.primitives.DateTime(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.imagebuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.imagebuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.Component
  ): zio.aws.imagebuilder.model.Component.ReadOnly = new Wrapper(impl)
}
