package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  ImagePipelineArn,
  ClientToken,
  NonEmptyString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateImagePipelineResponse(
    requestId: Optional[NonEmptyString] = Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent,
    imagePipelineArn: Optional[ImagePipelineArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.CreateImagePipelineResponse = {
    import CreateImagePipelineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.CreateImagePipelineResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        imagePipelineArn.map(value =>
          ImagePipelineArn.unwrap(value): java.lang.String
        )
      )(_.imagePipelineArn)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.CreateImagePipelineResponse.ReadOnly =
    zio.aws.imagebuilder.model.CreateImagePipelineResponse.wrap(buildAwsValue())
}
object CreateImagePipelineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.CreateImagePipelineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.CreateImagePipelineResponse =
      zio.aws.imagebuilder.model.CreateImagePipelineResponse(
        requestId.map(value => value),
        clientToken.map(value => value),
        imagePipelineArn.map(value => value)
      )
    def requestId: Optional[NonEmptyString]
    def clientToken: Optional[ClientToken]
    def imagePipelineArn: Optional[ImagePipelineArn]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getImagePipelineArn: ZIO[Any, AwsError, ImagePipelineArn] =
      AwsError.unwrapOptionField("imagePipelineArn", imagePipelineArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.CreateImagePipelineResponse
  ) extends zio.aws.imagebuilder.model.CreateImagePipelineResponse.ReadOnly {
    override val requestId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.imagebuilder.model.primitives.ClientToken(value))
    override val imagePipelineArn: Optional[ImagePipelineArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imagePipelineArn())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.ImagePipelineArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.CreateImagePipelineResponse
  ): zio.aws.imagebuilder.model.CreateImagePipelineResponse.ReadOnly =
    new Wrapper(impl)
}
