package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ImageState(
    status: Optional[zio.aws.imagebuilder.model.ImageStatus] = Optional.Absent,
    reason: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ImageState = {
    import ImageState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ImageState
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        reason.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.reason)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.ImageState.ReadOnly =
    zio.aws.imagebuilder.model.ImageState.wrap(buildAwsValue())
}
object ImageState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ImageState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ImageState =
      zio.aws.imagebuilder.model
        .ImageState(status.map(value => value), reason.map(value => value))
    def status: Optional[zio.aws.imagebuilder.model.ImageStatus]
    def reason: Optional[NonEmptyString]
    def getStatus: ZIO[Any, AwsError, zio.aws.imagebuilder.model.ImageStatus] =
      AwsError.unwrapOptionField("status", status)
    def getReason: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("reason", reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ImageState
  ) extends zio.aws.imagebuilder.model.ImageState.ReadOnly {
    override val status: Optional[zio.aws.imagebuilder.model.ImageStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.imagebuilder.model.ImageStatus.wrap(value))
    override val reason: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.reason())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ImageState
  ): zio.aws.imagebuilder.model.ImageState.ReadOnly = new Wrapper(impl)
}
