package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class S3ExportConfiguration(
    roleName: NonEmptyString,
    diskImageFormat: zio.aws.imagebuilder.model.DiskImageFormat,
    s3Bucket: NonEmptyString,
    s3Prefix: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.S3ExportConfiguration = {
    import S3ExportConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.S3ExportConfiguration
      .builder()
      .roleName(NonEmptyString.unwrap(roleName): java.lang.String)
      .diskImageFormat(diskImageFormat.unwrap)
      .s3Bucket(NonEmptyString.unwrap(s3Bucket): java.lang.String)
      .optionallyWith(
        s3Prefix.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.s3Prefix)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.S3ExportConfiguration.ReadOnly =
    zio.aws.imagebuilder.model.S3ExportConfiguration.wrap(buildAwsValue())
}
object S3ExportConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.S3ExportConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.S3ExportConfiguration =
      zio.aws.imagebuilder.model.S3ExportConfiguration(
        roleName,
        diskImageFormat,
        s3Bucket,
        s3Prefix.map(value => value)
      )
    def roleName: NonEmptyString
    def diskImageFormat: zio.aws.imagebuilder.model.DiskImageFormat
    def s3Bucket: NonEmptyString
    def s3Prefix: Optional[NonEmptyString]
    def getRoleName: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(roleName)
    def getDiskImageFormat
        : ZIO[Any, Nothing, zio.aws.imagebuilder.model.DiskImageFormat] =
      ZIO.succeed(diskImageFormat)
    def getS3Bucket: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(s3Bucket)
    def getS3Prefix: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("s3Prefix", s3Prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.S3ExportConfiguration
  ) extends zio.aws.imagebuilder.model.S3ExportConfiguration.ReadOnly {
    override val roleName: NonEmptyString =
      zio.aws.imagebuilder.model.primitives.NonEmptyString(impl.roleName())
    override val diskImageFormat: zio.aws.imagebuilder.model.DiskImageFormat =
      zio.aws.imagebuilder.model.DiskImageFormat.wrap(impl.diskImageFormat())
    override val s3Bucket: NonEmptyString =
      zio.aws.imagebuilder.model.primitives.NonEmptyString(impl.s3Bucket())
    override val s3Prefix: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Prefix())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.S3ExportConfiguration
  ): zio.aws.imagebuilder.model.S3ExportConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
