package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{PaginationToken, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListImageBuildVersionsResponse(
    requestId: Optional[NonEmptyString] = Optional.Absent,
    imageSummaryList: Optional[
      Iterable[zio.aws.imagebuilder.model.ImageSummary]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsResponse = {
    import ListImageBuildVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        imageSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.imageSummaryList)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.ListImageBuildVersionsResponse.ReadOnly =
    zio.aws.imagebuilder.model.ListImageBuildVersionsResponse
      .wrap(buildAwsValue())
}
object ListImageBuildVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ListImageBuildVersionsResponse =
      zio.aws.imagebuilder.model.ListImageBuildVersionsResponse(
        requestId.map(value => value),
        imageSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def requestId: Optional[NonEmptyString]
    def imageSummaryList
        : Optional[List[zio.aws.imagebuilder.model.ImageSummary.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getImageSummaryList: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.ImageSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("imageSummaryList", imageSummaryList)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsResponse
  ) extends zio.aws.imagebuilder.model.ListImageBuildVersionsResponse.ReadOnly {
    override val requestId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val imageSummaryList
        : Optional[List[zio.aws.imagebuilder.model.ImageSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageSummaryList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.imagebuilder.model.ImageSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsResponse
  ): zio.aws.imagebuilder.model.ListImageBuildVersionsResponse.ReadOnly =
    new Wrapper(impl)
}
