package zio.aws.imagebuilder
import zio.aws.imagebuilder.model.UpdateImagePipelineResponse.ReadOnly
import zio.aws.imagebuilder.model.{
  ListComponentBuildVersionsRequest,
  PutComponentPolicyRequest,
  CreateInfrastructureConfigurationRequest,
  GetInfrastructureConfigurationRequest,
  CreateDistributionConfigurationRequest,
  ImportVmImageRequest,
  GetDistributionConfigurationRequest,
  CreateContainerRecipeRequest,
  DeleteComponentRequest,
  PutImagePolicyRequest,
  DeleteImagePipelineRequest,
  ListTagsForResourceRequest,
  GetImageRecipePolicyRequest,
  DeleteImageRequest,
  CreateComponentRequest,
  PutContainerRecipePolicyRequest,
  ListDistributionConfigurationsRequest,
  DeleteDistributionConfigurationRequest,
  ImportComponentRequest,
  DeleteContainerRecipeRequest,
  DeleteImageRecipeRequest,
  GetImageRecipeRequest,
  ListImageBuildVersionsRequest,
  GetContainerRecipePolicyRequest,
  ListContainerRecipesRequest,
  GetContainerRecipeRequest,
  CancelImageCreationRequest,
  UpdateImagePipelineRequest,
  UntagResourceRequest,
  PutImageRecipePolicyRequest,
  CreateImageRecipeRequest,
  GetImagePolicyRequest,
  StartImagePipelineExecutionRequest,
  ListComponentsRequest,
  CreateImageRequest,
  ListImagePipelinesRequest,
  GetComponentPolicyRequest,
  ListImagePackagesRequest,
  GetComponentRequest,
  GetImageRequest,
  UpdateInfrastructureConfigurationRequest,
  ListImageRecipesRequest,
  ListInfrastructureConfigurationsRequest,
  DeleteInfrastructureConfigurationRequest,
  UpdateDistributionConfigurationRequest,
  GetImagePipelineRequest,
  TagResourceRequest,
  ListImagesRequest,
  CreateImagePipelineRequest,
  ListImagePipelineImagesRequest
}
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.imagebuilder.ImagebuilderAsyncClient
import zio.stream.ZStream
object ImagebuilderMock extends Mock[Imagebuilder] {
  object ListImages
      extends Stream[
        ListImagesRequest,
        AwsError,
        zio.aws.imagebuilder.model.ImageVersion.ReadOnly
      ]
  object ListImagesPaginated
      extends Effect[
        ListImagesRequest,
        AwsError,
        zio.aws.imagebuilder.model.ListImagesResponse.ReadOnly
      ]
  object ListImageRecipes
      extends Stream[
        ListImageRecipesRequest,
        AwsError,
        zio.aws.imagebuilder.model.ImageRecipeSummary.ReadOnly
      ]
  object ListImageRecipesPaginated
      extends Effect[
        ListImageRecipesRequest,
        AwsError,
        zio.aws.imagebuilder.model.ListImageRecipesResponse.ReadOnly
      ]
  object PutComponentPolicy
      extends Effect[
        PutComponentPolicyRequest,
        AwsError,
        zio.aws.imagebuilder.model.PutComponentPolicyResponse.ReadOnly
      ]
  object GetImageRecipe
      extends Effect[
        GetImageRecipeRequest,
        AwsError,
        zio.aws.imagebuilder.model.GetImageRecipeResponse.ReadOnly
      ]
  object ListImagePackages
      extends Stream[
        ListImagePackagesRequest,
        AwsError,
        zio.aws.imagebuilder.model.ImagePackage.ReadOnly
      ]
  object ListImagePackagesPaginated
      extends Effect[
        ListImagePackagesRequest,
        AwsError,
        zio.aws.imagebuilder.model.ListImagePackagesResponse.ReadOnly
      ]
  object GetComponentPolicy
      extends Effect[
        GetComponentPolicyRequest,
        AwsError,
        zio.aws.imagebuilder.model.GetComponentPolicyResponse.ReadOnly
      ]
  object GetContainerRecipe
      extends Effect[
        GetContainerRecipeRequest,
        AwsError,
        zio.aws.imagebuilder.model.GetContainerRecipeResponse.ReadOnly
      ]
  object StartImagePipelineExecution
      extends Effect[
        StartImagePipelineExecutionRequest,
        AwsError,
        zio.aws.imagebuilder.model.StartImagePipelineExecutionResponse.ReadOnly
      ]
  object UpdateDistributionConfiguration
      extends Effect[
        UpdateDistributionConfigurationRequest,
        AwsError,
        zio.aws.imagebuilder.model.UpdateDistributionConfigurationResponse.ReadOnly
      ]
  object DeleteImage
      extends Effect[
        DeleteImageRequest,
        AwsError,
        zio.aws.imagebuilder.model.DeleteImageResponse.ReadOnly
      ]
  object CreateImageRecipe
      extends Effect[
        CreateImageRecipeRequest,
        AwsError,
        zio.aws.imagebuilder.model.CreateImageRecipeResponse.ReadOnly
      ]
  object ListComponentBuildVersions
      extends Stream[
        ListComponentBuildVersionsRequest,
        AwsError,
        zio.aws.imagebuilder.model.ComponentSummary.ReadOnly
      ]
  object ListComponentBuildVersionsPaginated
      extends Effect[
        ListComponentBuildVersionsRequest,
        AwsError,
        zio.aws.imagebuilder.model.ListComponentBuildVersionsResponse.ReadOnly
      ]
  object PutImagePolicy
      extends Effect[
        PutImagePolicyRequest,
        AwsError,
        zio.aws.imagebuilder.model.PutImagePolicyResponse.ReadOnly
      ]
  object GetDistributionConfiguration
      extends Effect[
        GetDistributionConfigurationRequest,
        AwsError,
        zio.aws.imagebuilder.model.GetDistributionConfigurationResponse.ReadOnly
      ]
  object DeleteImageRecipe
      extends Effect[
        DeleteImageRecipeRequest,
        AwsError,
        zio.aws.imagebuilder.model.DeleteImageRecipeResponse.ReadOnly
      ]
  object CreateContainerRecipe
      extends Effect[
        CreateContainerRecipeRequest,
        AwsError,
        zio.aws.imagebuilder.model.CreateContainerRecipeResponse.ReadOnly
      ]
  object DeleteDistributionConfiguration
      extends Effect[
        DeleteDistributionConfigurationRequest,
        AwsError,
        zio.aws.imagebuilder.model.DeleteDistributionConfigurationResponse.ReadOnly
      ]
  object PutContainerRecipePolicy
      extends Effect[
        PutContainerRecipePolicyRequest,
        AwsError,
        zio.aws.imagebuilder.model.PutContainerRecipePolicyResponse.ReadOnly
      ]
  object CreateInfrastructureConfiguration
      extends Effect[
        CreateInfrastructureConfigurationRequest,
        AwsError,
        zio.aws.imagebuilder.model.CreateInfrastructureConfigurationResponse.ReadOnly
      ]
  object ListComponents
      extends Stream[
        ListComponentsRequest,
        AwsError,
        zio.aws.imagebuilder.model.ComponentVersion.ReadOnly
      ]
  object ListComponentsPaginated
      extends Effect[
        ListComponentsRequest,
        AwsError,
        zio.aws.imagebuilder.model.ListComponentsResponse.ReadOnly
      ]
  object CreateImage
      extends Effect[
        CreateImageRequest,
        AwsError,
        zio.aws.imagebuilder.model.CreateImageResponse.ReadOnly
      ]
  object DeleteInfrastructureConfiguration
      extends Effect[
        DeleteInfrastructureConfigurationRequest,
        AwsError,
        zio.aws.imagebuilder.model.DeleteInfrastructureConfigurationResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.imagebuilder.model.UntagResourceResponse.ReadOnly
      ]
  object DeleteComponent
      extends Effect[
        DeleteComponentRequest,
        AwsError,
        zio.aws.imagebuilder.model.DeleteComponentResponse.ReadOnly
      ]
  object ListImagePipelines
      extends Stream[
        ListImagePipelinesRequest,
        AwsError,
        zio.aws.imagebuilder.model.ImagePipeline.ReadOnly
      ]
  object ListImagePipelinesPaginated
      extends Effect[
        ListImagePipelinesRequest,
        AwsError,
        zio.aws.imagebuilder.model.ListImagePipelinesResponse.ReadOnly
      ]
  object ListDistributionConfigurations
      extends Stream[
        ListDistributionConfigurationsRequest,
        AwsError,
        zio.aws.imagebuilder.model.DistributionConfigurationSummary.ReadOnly
      ]
  object ListDistributionConfigurationsPaginated
      extends Effect[
        ListDistributionConfigurationsRequest,
        AwsError,
        zio.aws.imagebuilder.model.ListDistributionConfigurationsResponse.ReadOnly
      ]
  object GetContainerRecipePolicy
      extends Effect[
        GetContainerRecipePolicyRequest,
        AwsError,
        zio.aws.imagebuilder.model.GetContainerRecipePolicyResponse.ReadOnly
      ]
  object ListImagePipelineImages
      extends Stream[
        ListImagePipelineImagesRequest,
        AwsError,
        zio.aws.imagebuilder.model.ImageSummary.ReadOnly
      ]
  object ListImagePipelineImagesPaginated
      extends Effect[
        ListImagePipelineImagesRequest,
        AwsError,
        zio.aws.imagebuilder.model.ListImagePipelineImagesResponse.ReadOnly
      ]
  object CreateDistributionConfiguration
      extends Effect[
        CreateDistributionConfigurationRequest,
        AwsError,
        zio.aws.imagebuilder.model.CreateDistributionConfigurationResponse.ReadOnly
      ]
  object ImportComponent
      extends Effect[
        ImportComponentRequest,
        AwsError,
        zio.aws.imagebuilder.model.ImportComponentResponse.ReadOnly
      ]
  object CreateComponent
      extends Effect[
        CreateComponentRequest,
        AwsError,
        zio.aws.imagebuilder.model.CreateComponentResponse.ReadOnly
      ]
  object GetImagePipeline
      extends Effect[
        GetImagePipelineRequest,
        AwsError,
        zio.aws.imagebuilder.model.GetImagePipelineResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.imagebuilder.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.imagebuilder.model.TagResourceResponse.ReadOnly
      ]
  object CreateImagePipeline
      extends Effect[
        CreateImagePipelineRequest,
        AwsError,
        zio.aws.imagebuilder.model.CreateImagePipelineResponse.ReadOnly
      ]
  object ListInfrastructureConfigurations
      extends Stream[
        ListInfrastructureConfigurationsRequest,
        AwsError,
        zio.aws.imagebuilder.model.InfrastructureConfigurationSummary.ReadOnly
      ]
  object ListInfrastructureConfigurationsPaginated
      extends Effect[
        ListInfrastructureConfigurationsRequest,
        AwsError,
        zio.aws.imagebuilder.model.ListInfrastructureConfigurationsResponse.ReadOnly
      ]
  object GetInfrastructureConfiguration
      extends Effect[
        GetInfrastructureConfigurationRequest,
        AwsError,
        zio.aws.imagebuilder.model.GetInfrastructureConfigurationResponse.ReadOnly
      ]
  object DeleteContainerRecipe
      extends Effect[
        DeleteContainerRecipeRequest,
        AwsError,
        zio.aws.imagebuilder.model.DeleteContainerRecipeResponse.ReadOnly
      ]
  object GetImage
      extends Effect[
        GetImageRequest,
        AwsError,
        zio.aws.imagebuilder.model.GetImageResponse.ReadOnly
      ]
  object ListContainerRecipes
      extends Stream[
        ListContainerRecipesRequest,
        AwsError,
        zio.aws.imagebuilder.model.ContainerRecipeSummary.ReadOnly
      ]
  object ListContainerRecipesPaginated
      extends Effect[
        ListContainerRecipesRequest,
        AwsError,
        zio.aws.imagebuilder.model.ListContainerRecipesResponse.ReadOnly
      ]
  object DeleteImagePipeline
      extends Effect[
        DeleteImagePipelineRequest,
        AwsError,
        zio.aws.imagebuilder.model.DeleteImagePipelineResponse.ReadOnly
      ]
  object PutImageRecipePolicy
      extends Effect[
        PutImageRecipePolicyRequest,
        AwsError,
        zio.aws.imagebuilder.model.PutImageRecipePolicyResponse.ReadOnly
      ]
  object UpdateImagePipeline
      extends Effect[UpdateImagePipelineRequest, AwsError, ReadOnly]
  object GetImageRecipePolicy
      extends Effect[
        GetImageRecipePolicyRequest,
        AwsError,
        zio.aws.imagebuilder.model.GetImageRecipePolicyResponse.ReadOnly
      ]
  object ListImageBuildVersions
      extends Stream[
        ListImageBuildVersionsRequest,
        AwsError,
        zio.aws.imagebuilder.model.ImageSummary.ReadOnly
      ]
  object ListImageBuildVersionsPaginated
      extends Effect[
        ListImageBuildVersionsRequest,
        AwsError,
        zio.aws.imagebuilder.model.ListImageBuildVersionsResponse.ReadOnly
      ]
  object UpdateInfrastructureConfiguration
      extends Effect[
        UpdateInfrastructureConfigurationRequest,
        AwsError,
        zio.aws.imagebuilder.model.UpdateInfrastructureConfigurationResponse.ReadOnly
      ]
  object GetComponent
      extends Effect[
        GetComponentRequest,
        AwsError,
        zio.aws.imagebuilder.model.GetComponentResponse.ReadOnly
      ]
  object ImportVmImage
      extends Effect[
        ImportVmImageRequest,
        AwsError,
        zio.aws.imagebuilder.model.ImportVmImageResponse.ReadOnly
      ]
  object CancelImageCreation
      extends Effect[
        CancelImageCreationRequest,
        AwsError,
        zio.aws.imagebuilder.model.CancelImageCreationResponse.ReadOnly
      ]
  object GetImagePolicy
      extends Effect[
        GetImagePolicyRequest,
        AwsError,
        zio.aws.imagebuilder.model.GetImagePolicyResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Imagebuilder] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Imagebuilder] { rts =>
        zio.ZIO.succeed {
          new Imagebuilder {
            val api: ImagebuilderAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Imagebuilder = this
            def listImages(request: ListImagesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.imagebuilder.model.ImageVersion.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListImages, request)
                }
                .getOrThrowFiberFailure()
            }
            def listImagesPaginated(request: ListImagesRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.ListImagesResponse.ReadOnly
            ] = proxy(ListImagesPaginated, request)
            def listImageRecipes(request: ListImageRecipesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.imagebuilder.model.ImageRecipeSummary.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListImageRecipes, request)
                }
                .getOrThrowFiberFailure()
            }
            def listImageRecipesPaginated(request: ListImageRecipesRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.ListImageRecipesResponse.ReadOnly
            ] = proxy(ListImageRecipesPaginated, request)
            def putComponentPolicy(request: PutComponentPolicyRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.PutComponentPolicyResponse.ReadOnly
            ] = proxy(PutComponentPolicy, request)
            def getImageRecipe(request: GetImageRecipeRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.GetImageRecipeResponse.ReadOnly
            ] = proxy(GetImageRecipe, request)
            def listImagePackages(request: ListImagePackagesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.imagebuilder.model.ImagePackage.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListImagePackages, request)
                }
                .getOrThrowFiberFailure()
            }
            def listImagePackagesPaginated(
                request: ListImagePackagesRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.ListImagePackagesResponse.ReadOnly
            ] = proxy(ListImagePackagesPaginated, request)
            def getComponentPolicy(request: GetComponentPolicyRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.GetComponentPolicyResponse.ReadOnly
            ] = proxy(GetComponentPolicy, request)
            def getContainerRecipe(request: GetContainerRecipeRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.GetContainerRecipeResponse.ReadOnly
            ] = proxy(GetContainerRecipe, request)
            def startImagePipelineExecution(
                request: StartImagePipelineExecutionRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.StartImagePipelineExecutionResponse.ReadOnly
            ] = proxy(StartImagePipelineExecution, request)
            def updateDistributionConfiguration(
                request: UpdateDistributionConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.UpdateDistributionConfigurationResponse.ReadOnly
            ] = proxy(UpdateDistributionConfiguration, request)
            def deleteImage(request: DeleteImageRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.DeleteImageResponse.ReadOnly
            ] = proxy(DeleteImage, request)
            def createImageRecipe(request: CreateImageRecipeRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.CreateImageRecipeResponse.ReadOnly
            ] = proxy(CreateImageRecipe, request)
            def listComponentBuildVersions(
                request: ListComponentBuildVersionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.imagebuilder.model.ComponentSummary.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListComponentBuildVersions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listComponentBuildVersionsPaginated(
                request: ListComponentBuildVersionsRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.ListComponentBuildVersionsResponse.ReadOnly
            ] = proxy(ListComponentBuildVersionsPaginated, request)
            def putImagePolicy(request: PutImagePolicyRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.PutImagePolicyResponse.ReadOnly
            ] = proxy(PutImagePolicy, request)
            def getDistributionConfiguration(
                request: GetDistributionConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.GetDistributionConfigurationResponse.ReadOnly
            ] = proxy(GetDistributionConfiguration, request)
            def deleteImageRecipe(request: DeleteImageRecipeRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.DeleteImageRecipeResponse.ReadOnly
            ] = proxy(DeleteImageRecipe, request)
            def createContainerRecipe(
                request: CreateContainerRecipeRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.CreateContainerRecipeResponse.ReadOnly
            ] = proxy(CreateContainerRecipe, request)
            def deleteDistributionConfiguration(
                request: DeleteDistributionConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.DeleteDistributionConfigurationResponse.ReadOnly
            ] = proxy(DeleteDistributionConfiguration, request)
            def putContainerRecipePolicy(
                request: PutContainerRecipePolicyRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.PutContainerRecipePolicyResponse.ReadOnly
            ] = proxy(PutContainerRecipePolicy, request)
            def createInfrastructureConfiguration(
                request: CreateInfrastructureConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.CreateInfrastructureConfigurationResponse.ReadOnly
            ] = proxy(CreateInfrastructureConfiguration, request)
            def listComponents(request: ListComponentsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.imagebuilder.model.ComponentVersion.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListComponents, request)
                }
                .getOrThrowFiberFailure()
            }
            def listComponentsPaginated(request: ListComponentsRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.ListComponentsResponse.ReadOnly
            ] = proxy(ListComponentsPaginated, request)
            def createImage(request: CreateImageRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.CreateImageResponse.ReadOnly
            ] = proxy(CreateImage, request)
            def deleteInfrastructureConfiguration(
                request: DeleteInfrastructureConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.DeleteInfrastructureConfigurationResponse.ReadOnly
            ] = proxy(DeleteInfrastructureConfiguration, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def deleteComponent(request: DeleteComponentRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.DeleteComponentResponse.ReadOnly
            ] = proxy(DeleteComponent, request)
            def listImagePipelines(request: ListImagePipelinesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.imagebuilder.model.ImagePipeline.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListImagePipelines, request)
                }
                .getOrThrowFiberFailure()
            }
            def listImagePipelinesPaginated(
                request: ListImagePipelinesRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.ListImagePipelinesResponse.ReadOnly
            ] = proxy(ListImagePipelinesPaginated, request)
            def listDistributionConfigurations(
                request: ListDistributionConfigurationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.imagebuilder.model.DistributionConfigurationSummary.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDistributionConfigurations, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDistributionConfigurationsPaginated(
                request: ListDistributionConfigurationsRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.ListDistributionConfigurationsResponse.ReadOnly
            ] = proxy(ListDistributionConfigurationsPaginated, request)
            def getContainerRecipePolicy(
                request: GetContainerRecipePolicyRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.GetContainerRecipePolicyResponse.ReadOnly
            ] = proxy(GetContainerRecipePolicy, request)
            def listImagePipelineImages(
                request: ListImagePipelineImagesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.imagebuilder.model.ImageSummary.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListImagePipelineImages, request)
                }
                .getOrThrowFiberFailure()
            }
            def listImagePipelineImagesPaginated(
                request: ListImagePipelineImagesRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.ListImagePipelineImagesResponse.ReadOnly
            ] = proxy(ListImagePipelineImagesPaginated, request)
            def createDistributionConfiguration(
                request: CreateDistributionConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.CreateDistributionConfigurationResponse.ReadOnly
            ] = proxy(CreateDistributionConfiguration, request)
            def importComponent(request: ImportComponentRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.ImportComponentResponse.ReadOnly
            ] = proxy(ImportComponent, request)
            def createComponent(request: CreateComponentRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.CreateComponentResponse.ReadOnly
            ] = proxy(CreateComponent, request)
            def getImagePipeline(request: GetImagePipelineRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.GetImagePipelineResponse.ReadOnly
            ] = proxy(GetImagePipeline, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def createImagePipeline(request: CreateImagePipelineRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.CreateImagePipelineResponse.ReadOnly
            ] = proxy(CreateImagePipeline, request)
            def listInfrastructureConfigurations(
                request: ListInfrastructureConfigurationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.imagebuilder.model.InfrastructureConfigurationSummary.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListInfrastructureConfigurations, request)
                }
                .getOrThrowFiberFailure()
            }
            def listInfrastructureConfigurationsPaginated(
                request: ListInfrastructureConfigurationsRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.ListInfrastructureConfigurationsResponse.ReadOnly
            ] = proxy(ListInfrastructureConfigurationsPaginated, request)
            def getInfrastructureConfiguration(
                request: GetInfrastructureConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.GetInfrastructureConfigurationResponse.ReadOnly
            ] = proxy(GetInfrastructureConfiguration, request)
            def deleteContainerRecipe(
                request: DeleteContainerRecipeRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.DeleteContainerRecipeResponse.ReadOnly
            ] = proxy(DeleteContainerRecipe, request)
            def getImage(request: GetImageRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.GetImageResponse.ReadOnly
            ] = proxy(GetImage, request)
            def listContainerRecipes(
                request: ListContainerRecipesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.imagebuilder.model.ContainerRecipeSummary.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListContainerRecipes, request)
                }
                .getOrThrowFiberFailure()
            }
            def listContainerRecipesPaginated(
                request: ListContainerRecipesRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.ListContainerRecipesResponse.ReadOnly
            ] = proxy(ListContainerRecipesPaginated, request)
            def deleteImagePipeline(request: DeleteImagePipelineRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.DeleteImagePipelineResponse.ReadOnly
            ] = proxy(DeleteImagePipeline, request)
            def putImageRecipePolicy(request: PutImageRecipePolicyRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.PutImageRecipePolicyResponse.ReadOnly
            ] = proxy(PutImageRecipePolicy, request)
            def updateImagePipeline(
                request: UpdateImagePipelineRequest
            ): IO[AwsError, ReadOnly] = proxy(UpdateImagePipeline, request)
            def getImageRecipePolicy(request: GetImageRecipePolicyRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.GetImageRecipePolicyResponse.ReadOnly
            ] = proxy(GetImageRecipePolicy, request)
            def listImageBuildVersions(
                request: ListImageBuildVersionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.imagebuilder.model.ImageSummary.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListImageBuildVersions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listImageBuildVersionsPaginated(
                request: ListImageBuildVersionsRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.ListImageBuildVersionsResponse.ReadOnly
            ] = proxy(ListImageBuildVersionsPaginated, request)
            def updateInfrastructureConfiguration(
                request: UpdateInfrastructureConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.imagebuilder.model.UpdateInfrastructureConfigurationResponse.ReadOnly
            ] = proxy(UpdateInfrastructureConfiguration, request)
            def getComponent(request: GetComponentRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.GetComponentResponse.ReadOnly
            ] = proxy(GetComponent, request)
            def importVmImage(request: ImportVmImageRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.ImportVmImageResponse.ReadOnly
            ] = proxy(ImportVmImage, request)
            def cancelImageCreation(request: CancelImageCreationRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.CancelImageCreationResponse.ReadOnly
            ] = proxy(CancelImageCreation, request)
            def getImagePolicy(request: GetImagePolicyRequest): IO[
              AwsError,
              zio.aws.imagebuilder.model.GetImagePolicyResponse.ReadOnly
            ] = proxy(GetImagePolicy, request)
          }
        }
      }
    }
  }
}
