package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{PaginationToken, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListComponentBuildVersionsResponse(
    requestId: Optional[NonEmptyString] = Optional.Absent,
    componentSummaryList: Optional[
      Iterable[zio.aws.imagebuilder.model.ComponentSummary]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsResponse = {
    import ListComponentBuildVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        componentSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.componentSummaryList)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.ListComponentBuildVersionsResponse.ReadOnly =
    zio.aws.imagebuilder.model.ListComponentBuildVersionsResponse
      .wrap(buildAwsValue())
}
object ListComponentBuildVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.ListComponentBuildVersionsResponse =
      zio.aws.imagebuilder.model.ListComponentBuildVersionsResponse(
        requestId.map(value => value),
        componentSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def requestId: Optional[NonEmptyString]
    def componentSummaryList
        : Optional[List[zio.aws.imagebuilder.model.ComponentSummary.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getComponentSummaryList: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.ComponentSummary.ReadOnly
    ]] =
      AwsError.unwrapOptionField("componentSummaryList", componentSummaryList)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsResponse
  ) extends zio.aws.imagebuilder.model.ListComponentBuildVersionsResponse.ReadOnly {
    override val requestId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val componentSummaryList
        : Optional[List[zio.aws.imagebuilder.model.ComponentSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.componentSummaryList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.imagebuilder.model.ComponentSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListComponentBuildVersionsResponse
  ): zio.aws.imagebuilder.model.ListComponentBuildVersionsResponse.ReadOnly =
    new Wrapper(impl)
}
