package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  ImageBuilderArn,
  TagValue,
  DateTime,
  VersionNumber,
  DockerFileTemplate,
  NullableBoolean,
  NonEmptyString,
  ResourceName,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ContainerRecipe(
    arn: Optional[ImageBuilderArn] = Optional.Absent,
    containerType: Optional[zio.aws.imagebuilder.model.ContainerType] =
      Optional.Absent,
    name: Optional[ResourceName] = Optional.Absent,
    description: Optional[NonEmptyString] = Optional.Absent,
    platform: Optional[zio.aws.imagebuilder.model.Platform] = Optional.Absent,
    owner: Optional[NonEmptyString] = Optional.Absent,
    version: Optional[VersionNumber] = Optional.Absent,
    components: Optional[
      Iterable[zio.aws.imagebuilder.model.ComponentConfiguration]
    ] = Optional.Absent,
    instanceConfiguration: Optional[
      zio.aws.imagebuilder.model.InstanceConfiguration
    ] = Optional.Absent,
    dockerfileTemplateData: Optional[DockerFileTemplate] = Optional.Absent,
    kmsKeyId: Optional[NonEmptyString] = Optional.Absent,
    encrypted: Optional[NullableBoolean] = Optional.Absent,
    parentImage: Optional[NonEmptyString] = Optional.Absent,
    dateCreated: Optional[DateTime] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    workingDirectory: Optional[NonEmptyString] = Optional.Absent,
    targetRepository: Optional[
      zio.aws.imagebuilder.model.TargetContainerRepository
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ContainerRecipe = {
    import ContainerRecipe.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ContainerRecipe
      .builder()
      .optionallyWith(
        arn.map(value => ImageBuilderArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(containerType.map(value => value.unwrap))(_.containerType)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .optionallyWith(
        owner.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.owner)
      .optionallyWith(
        version.map(value => VersionNumber.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(
        components.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.components)
      .optionallyWith(
        instanceConfiguration.map(value => value.buildAwsValue())
      )(_.instanceConfiguration)
      .optionallyWith(
        dockerfileTemplateData.map(value =>
          DockerFileTemplate.unwrap(value): java.lang.String
        )
      )(_.dockerfileTemplateData)
      .optionallyWith(
        kmsKeyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(
        parentImage.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.parentImage)
      .optionallyWith(
        dateCreated.map(value => DateTime.unwrap(value): java.lang.String)
      )(_.dateCreated)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        workingDirectory.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.workingDirectory)
      .optionallyWith(targetRepository.map(value => value.buildAwsValue()))(
        _.targetRepository
      )
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.ContainerRecipe.ReadOnly =
    zio.aws.imagebuilder.model.ContainerRecipe.wrap(buildAwsValue())
}
object ContainerRecipe {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ContainerRecipe
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ContainerRecipe =
      zio.aws.imagebuilder.model.ContainerRecipe(
        arn.map(value => value),
        containerType.map(value => value),
        name.map(value => value),
        description.map(value => value),
        platform.map(value => value),
        owner.map(value => value),
        version.map(value => value),
        components.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        instanceConfiguration.map(value => value.asEditable),
        dockerfileTemplateData.map(value => value),
        kmsKeyId.map(value => value),
        encrypted.map(value => value),
        parentImage.map(value => value),
        dateCreated.map(value => value),
        tags.map(value => value),
        workingDirectory.map(value => value),
        targetRepository.map(value => value.asEditable)
      )
    def arn: Optional[ImageBuilderArn]
    def containerType: Optional[zio.aws.imagebuilder.model.ContainerType]
    def name: Optional[ResourceName]
    def description: Optional[NonEmptyString]
    def platform: Optional[zio.aws.imagebuilder.model.Platform]
    def owner: Optional[NonEmptyString]
    def version: Optional[VersionNumber]
    def components: Optional[
      List[zio.aws.imagebuilder.model.ComponentConfiguration.ReadOnly]
    ]
    def instanceConfiguration
        : Optional[zio.aws.imagebuilder.model.InstanceConfiguration.ReadOnly]
    def dockerfileTemplateData: Optional[DockerFileTemplate]
    def kmsKeyId: Optional[NonEmptyString]
    def encrypted: Optional[NullableBoolean]
    def parentImage: Optional[NonEmptyString]
    def dateCreated: Optional[DateTime]
    def tags: Optional[Map[TagKey, TagValue]]
    def workingDirectory: Optional[NonEmptyString]
    def targetRepository: Optional[
      zio.aws.imagebuilder.model.TargetContainerRepository.ReadOnly
    ]
    def getArn: ZIO[Any, AwsError, ImageBuilderArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getContainerType
        : ZIO[Any, AwsError, zio.aws.imagebuilder.model.ContainerType] =
      AwsError.unwrapOptionField("containerType", containerType)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getPlatform: ZIO[Any, AwsError, zio.aws.imagebuilder.model.Platform] =
      AwsError.unwrapOptionField("platform", platform)
    def getOwner: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("owner", owner)
    def getVersion: ZIO[Any, AwsError, VersionNumber] =
      AwsError.unwrapOptionField("version", version)
    def getComponents: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.ComponentConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("components", components)
    def getInstanceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.InstanceConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("instanceConfiguration", instanceConfiguration)
    def getDockerfileTemplateData: ZIO[Any, AwsError, DockerFileTemplate] =
      AwsError.unwrapOptionField(
        "dockerfileTemplateData",
        dockerfileTemplateData
      )
    def getKmsKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getEncrypted: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getParentImage: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("parentImage", parentImage)
    def getDateCreated: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("dateCreated", dateCreated)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getWorkingDirectory: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("workingDirectory", workingDirectory)
    def getTargetRepository: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.TargetContainerRepository.ReadOnly
    ] = AwsError.unwrapOptionField("targetRepository", targetRepository)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ContainerRecipe
  ) extends zio.aws.imagebuilder.model.ContainerRecipe.ReadOnly {
    override val arn: Optional[ImageBuilderArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.ImageBuilderArn(value)
      )
    override val containerType
        : Optional[zio.aws.imagebuilder.model.ContainerType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.containerType())
        .map(value => zio.aws.imagebuilder.model.ContainerType.wrap(value))
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.imagebuilder.model.primitives.ResourceName(value))
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val platform: Optional[zio.aws.imagebuilder.model.Platform] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platform())
        .map(value => zio.aws.imagebuilder.model.Platform.wrap(value))
    override val owner: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.owner())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val version: Optional[VersionNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.imagebuilder.model.primitives.VersionNumber(value))
    override val components: Optional[
      List[zio.aws.imagebuilder.model.ComponentConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.components())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.ComponentConfiguration.wrap(item)
        }.toList
      )
    override val instanceConfiguration
        : Optional[zio.aws.imagebuilder.model.InstanceConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceConfiguration())
        .map(value =>
          zio.aws.imagebuilder.model.InstanceConfiguration.wrap(value)
        )
    override val dockerfileTemplateData: Optional[DockerFileTemplate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dockerfileTemplateData())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.DockerFileTemplate(value)
        )
    override val kmsKeyId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val encrypted: Optional[NullableBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.encrypted())
      .map(value => value: NullableBoolean)
    override val parentImage: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.parentImage())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val dateCreated: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.dateCreated())
      .map(value => zio.aws.imagebuilder.model.primitives.DateTime(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.imagebuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.imagebuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val workingDirectory: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workingDirectory())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.NonEmptyString(value)
        )
    override val targetRepository: Optional[
      zio.aws.imagebuilder.model.TargetContainerRepository.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.targetRepository())
      .map(value =>
        zio.aws.imagebuilder.model.TargetContainerRepository.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ContainerRecipe
  ): zio.aws.imagebuilder.model.ContainerRecipe.ReadOnly = new Wrapper(impl)
}
