package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  TagValue,
  VersionNumber,
  ClientToken,
  NonEmptyString,
  ResourceName,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateImageRecipeRequest(
    name: ResourceName,
    description: Optional[NonEmptyString] = Optional.Absent,
    semanticVersion: VersionNumber,
    components: Iterable[zio.aws.imagebuilder.model.ComponentConfiguration],
    parentImage: NonEmptyString,
    blockDeviceMappings: Optional[
      Iterable[zio.aws.imagebuilder.model.InstanceBlockDeviceMapping]
    ] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    workingDirectory: Optional[NonEmptyString] = Optional.Absent,
    additionalInstanceConfiguration: Optional[
      zio.aws.imagebuilder.model.AdditionalInstanceConfiguration
    ] = Optional.Absent,
    clientToken: ClientToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.CreateImageRecipeRequest = {
    import CreateImageRecipeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.CreateImageRecipeRequest
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .semanticVersion(VersionNumber.unwrap(semanticVersion): java.lang.String)
      .components(components.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .parentImage(NonEmptyString.unwrap(parentImage): java.lang.String)
      .optionallyWith(
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blockDeviceMappings)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        workingDirectory.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.workingDirectory)
      .optionallyWith(
        additionalInstanceConfiguration.map(value => value.buildAwsValue())
      )(_.additionalInstanceConfiguration)
      .clientToken(ClientToken.unwrap(clientToken): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.CreateImageRecipeRequest.ReadOnly =
    zio.aws.imagebuilder.model.CreateImageRecipeRequest.wrap(buildAwsValue())
}
object CreateImageRecipeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.CreateImageRecipeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.CreateImageRecipeRequest =
      zio.aws.imagebuilder.model.CreateImageRecipeRequest(
        name,
        description.map(value => value),
        semanticVersion,
        components.map { item =>
          item.asEditable
        },
        parentImage,
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value => value),
        workingDirectory.map(value => value),
        additionalInstanceConfiguration.map(value => value.asEditable),
        clientToken
      )
    def name: ResourceName
    def description: Optional[NonEmptyString]
    def semanticVersion: VersionNumber
    def components
        : List[zio.aws.imagebuilder.model.ComponentConfiguration.ReadOnly]
    def parentImage: NonEmptyString
    def blockDeviceMappings: Optional[
      List[zio.aws.imagebuilder.model.InstanceBlockDeviceMapping.ReadOnly]
    ]
    def tags: Optional[Map[TagKey, TagValue]]
    def workingDirectory: Optional[NonEmptyString]
    def additionalInstanceConfiguration: Optional[
      zio.aws.imagebuilder.model.AdditionalInstanceConfiguration.ReadOnly
    ]
    def clientToken: ClientToken
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getSemanticVersion: ZIO[Any, Nothing, VersionNumber] =
      ZIO.succeed(semanticVersion)
    def getComponents: ZIO[Any, Nothing, List[
      zio.aws.imagebuilder.model.ComponentConfiguration.ReadOnly
    ]] = ZIO.succeed(components)
    def getParentImage: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(parentImage)
    def getBlockDeviceMappings: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.InstanceBlockDeviceMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("blockDeviceMappings", blockDeviceMappings)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getWorkingDirectory: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("workingDirectory", workingDirectory)
    def getAdditionalInstanceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.AdditionalInstanceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "additionalInstanceConfiguration",
      additionalInstanceConfiguration
    )
    def getClientToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.CreateImageRecipeRequest
  ) extends zio.aws.imagebuilder.model.CreateImageRecipeRequest.ReadOnly {
    override val name: ResourceName =
      zio.aws.imagebuilder.model.primitives.ResourceName(impl.name())
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val semanticVersion: VersionNumber =
      zio.aws.imagebuilder.model.primitives
        .VersionNumber(impl.semanticVersion())
    override val components
        : List[zio.aws.imagebuilder.model.ComponentConfiguration.ReadOnly] =
      impl
        .components()
        .asScala
        .map { item =>
          zio.aws.imagebuilder.model.ComponentConfiguration.wrap(item)
        }
        .toList
    override val parentImage: NonEmptyString =
      zio.aws.imagebuilder.model.primitives.NonEmptyString(impl.parentImage())
    override val blockDeviceMappings: Optional[
      List[zio.aws.imagebuilder.model.InstanceBlockDeviceMapping.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.blockDeviceMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.InstanceBlockDeviceMapping.wrap(item)
        }.toList
      )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.imagebuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.imagebuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val workingDirectory: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workingDirectory())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.NonEmptyString(value)
        )
    override val additionalInstanceConfiguration: Optional[
      zio.aws.imagebuilder.model.AdditionalInstanceConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalInstanceConfiguration())
      .map(value =>
        zio.aws.imagebuilder.model.AdditionalInstanceConfiguration.wrap(value)
      )
    override val clientToken: ClientToken =
      zio.aws.imagebuilder.model.primitives.ClientToken(impl.clientToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.CreateImageRecipeRequest
  ): zio.aws.imagebuilder.model.CreateImageRecipeRequest.ReadOnly = new Wrapper(
    impl
  )
}
