package zio.aws.imagebuilder.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.imagebuilder.model.primitives.{
  PaginationToken,
  RestrictedInteger,
  ImageVersionArn
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListImageBuildVersionsRequest(
    imageVersionArn: ImageVersionArn,
    filters: Optional[Iterable[zio.aws.imagebuilder.model.Filter]] =
      Optional.Absent,
    maxResults: Optional[RestrictedInteger] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsRequest = {
    import ListImageBuildVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsRequest
      .builder()
      .imageVersionArn(
        ImageVersionArn.unwrap(imageVersionArn): java.lang.String
      )
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => RestrictedInteger.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.ListImageBuildVersionsRequest.ReadOnly =
    zio.aws.imagebuilder.model.ListImageBuildVersionsRequest
      .wrap(buildAwsValue())
}
object ListImageBuildVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ListImageBuildVersionsRequest =
      zio.aws.imagebuilder.model.ListImageBuildVersionsRequest(
        imageVersionArn,
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def imageVersionArn: ImageVersionArn
    def filters: Optional[List[zio.aws.imagebuilder.model.Filter.ReadOnly]]
    def maxResults: Optional[RestrictedInteger]
    def nextToken: Optional[PaginationToken]
    def getImageVersionArn: ZIO[Any, Nothing, ImageVersionArn] =
      ZIO.succeed(imageVersionArn)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.imagebuilder.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, RestrictedInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsRequest
  ) extends zio.aws.imagebuilder.model.ListImageBuildVersionsRequest.ReadOnly {
    override val imageVersionArn: ImageVersionArn =
      zio.aws.imagebuilder.model.primitives
        .ImageVersionArn(impl.imageVersionArn())
    override val filters
        : Optional[List[zio.aws.imagebuilder.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.imagebuilder.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Optional[RestrictedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.RestrictedInteger(value)
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListImageBuildVersionsRequest
  ): zio.aws.imagebuilder.model.ListImageBuildVersionsRequest.ReadOnly =
    new Wrapper(impl)
}
