package zio.aws.imagebuilder.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.imagebuilder.model.primitives.{
  EbsIopsInteger,
  EbsVolumeSizeInteger,
  NullableBoolean,
  EbsVolumeThroughput,
  NonEmptyString
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class EbsInstanceBlockDeviceSpecification(
    encrypted: Optional[NullableBoolean] = Optional.Absent,
    deleteOnTermination: Optional[NullableBoolean] = Optional.Absent,
    iops: Optional[EbsIopsInteger] = Optional.Absent,
    kmsKeyId: Optional[NonEmptyString] = Optional.Absent,
    snapshotId: Optional[NonEmptyString] = Optional.Absent,
    volumeSize: Optional[EbsVolumeSizeInteger] = Optional.Absent,
    volumeType: Optional[zio.aws.imagebuilder.model.EbsVolumeType] =
      Optional.Absent,
    throughput: Optional[EbsVolumeThroughput] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.EbsInstanceBlockDeviceSpecification = {
    import EbsInstanceBlockDeviceSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.EbsInstanceBlockDeviceSpecification
      .builder()
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(
        deleteOnTermination.map(value => value: java.lang.Boolean)
      )(_.deleteOnTermination)
      .optionallyWith(iops.map(value => EbsIopsInteger.unwrap(value): Integer))(
        _.iops
      )
      .optionallyWith(
        kmsKeyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        snapshotId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.snapshotId)
      .optionallyWith(
        volumeSize.map(value => EbsVolumeSizeInteger.unwrap(value): Integer)
      )(_.volumeSize)
      .optionallyWith(volumeType.map(value => value.unwrap))(_.volumeType)
      .optionallyWith(
        throughput.map(value => EbsVolumeThroughput.unwrap(value): Integer)
      )(_.throughput)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.EbsInstanceBlockDeviceSpecification.ReadOnly =
    zio.aws.imagebuilder.model.EbsInstanceBlockDeviceSpecification
      .wrap(buildAwsValue())
}
object EbsInstanceBlockDeviceSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.EbsInstanceBlockDeviceSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.EbsInstanceBlockDeviceSpecification =
      zio.aws.imagebuilder.model.EbsInstanceBlockDeviceSpecification(
        encrypted.map(value => value),
        deleteOnTermination.map(value => value),
        iops.map(value => value),
        kmsKeyId.map(value => value),
        snapshotId.map(value => value),
        volumeSize.map(value => value),
        volumeType.map(value => value),
        throughput.map(value => value)
      )
    def encrypted: Optional[NullableBoolean]
    def deleteOnTermination: Optional[NullableBoolean]
    def iops: Optional[EbsIopsInteger]
    def kmsKeyId: Optional[NonEmptyString]
    def snapshotId: Optional[NonEmptyString]
    def volumeSize: Optional[EbsVolumeSizeInteger]
    def volumeType: Optional[zio.aws.imagebuilder.model.EbsVolumeType]
    def throughput: Optional[EbsVolumeThroughput]
    def getEncrypted: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getDeleteOnTermination: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("deleteOnTermination", deleteOnTermination)
    def getIops: ZIO[Any, AwsError, EbsIopsInteger] =
      AwsError.unwrapOptionField("iops", iops)
    def getKmsKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getSnapshotId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getVolumeSize: ZIO[Any, AwsError, EbsVolumeSizeInteger] =
      AwsError.unwrapOptionField("volumeSize", volumeSize)
    def getVolumeType
        : ZIO[Any, AwsError, zio.aws.imagebuilder.model.EbsVolumeType] =
      AwsError.unwrapOptionField("volumeType", volumeType)
    def getThroughput: ZIO[Any, AwsError, EbsVolumeThroughput] =
      AwsError.unwrapOptionField("throughput", throughput)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.EbsInstanceBlockDeviceSpecification
  ) extends zio.aws.imagebuilder.model.EbsInstanceBlockDeviceSpecification.ReadOnly {
    override val encrypted: Optional[NullableBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.encrypted())
      .map(value => value: NullableBoolean)
    override val deleteOnTermination: Optional[NullableBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deleteOnTermination())
        .map(value => value: NullableBoolean)
    override val iops: Optional[EbsIopsInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.iops())
      .map(value => zio.aws.imagebuilder.model.primitives.EbsIopsInteger(value))
    override val kmsKeyId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val snapshotId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val volumeSize: Optional[EbsVolumeSizeInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumeSize())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.EbsVolumeSizeInteger(value)
        )
    override val volumeType
        : Optional[zio.aws.imagebuilder.model.EbsVolumeType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumeType())
        .map(value => zio.aws.imagebuilder.model.EbsVolumeType.wrap(value))
    override val throughput: Optional[EbsVolumeThroughput] =
      zio.aws.core.internal
        .optionalFromNullable(impl.throughput())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.EbsVolumeThroughput(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.EbsInstanceBlockDeviceSpecification
  ): zio.aws.imagebuilder.model.EbsInstanceBlockDeviceSpecification.ReadOnly =
    new Wrapper(impl)
}
