package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ComponentState(
    status: Optional[zio.aws.imagebuilder.model.ComponentStatus] =
      Optional.Absent,
    reason: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ComponentState = {
    import ComponentState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ComponentState
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        reason.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.reason)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.ComponentState.ReadOnly =
    zio.aws.imagebuilder.model.ComponentState.wrap(buildAwsValue())
}
object ComponentState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ComponentState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ComponentState =
      zio.aws.imagebuilder.model
        .ComponentState(status.map(value => value), reason.map(value => value))
    def status: Optional[zio.aws.imagebuilder.model.ComponentStatus]
    def reason: Optional[NonEmptyString]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.imagebuilder.model.ComponentStatus] =
      AwsError.unwrapOptionField("status", status)
    def getReason: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("reason", reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ComponentState
  ) extends zio.aws.imagebuilder.model.ComponentState.ReadOnly {
    override val status: Optional[zio.aws.imagebuilder.model.ComponentStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.imagebuilder.model.ComponentStatus.wrap(value))
    override val reason: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.reason())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ComponentState
  ): zio.aws.imagebuilder.model.ComponentState.ReadOnly = new Wrapper(impl)
}
